/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.googlecode.gwt.test.BrowserSimulator;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtConfig;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSimulatorImpl
implements BrowserSimulator,
AfterTestCallback {
    private static final BrowserSimulatorImpl INSTANCE = new BrowserSimulatorImpl();
    private final Queue<Command> asyncCallbackCommands = new LinkedList<Command>();
    private final Queue<Scheduler.ScheduledCommand> deferredScheduledCommands = new LinkedList<Scheduler.ScheduledCommand>();
    private final List<Scheduler.RepeatingCommand> entryRepeatingCommands = new LinkedList<Scheduler.RepeatingCommand>();
    private final Queue<Scheduler.ScheduledCommand> entryScheduledCommands = new LinkedList<Scheduler.ScheduledCommand>();
    private final List<Scheduler.RepeatingCommand> finallyRepeatingCommands = new LinkedList<Scheduler.RepeatingCommand>();
    private final Queue<Scheduler.ScheduledCommand> finallyScheduledCommands = new LinkedList<Scheduler.ScheduledCommand>();
    private boolean isTriggering;

    public static BrowserSimulatorImpl get() {
        return INSTANCE;
    }

    private BrowserSimulatorImpl() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() throws Throwable {
        if (this.deferredScheduledCommands.size() == 0 && this.finallyScheduledCommands.size() == 0 && this.finallyRepeatingCommands.size() == 0 && this.entryScheduledCommands.size() == 0 && this.entryRepeatingCommands.size() == 0 && this.asyncCallbackCommands.size() == 0) {
            return;
        }
        String testName = GwtConfig.get().getModuleRunner().getClass().getSimpleName();
        String format = "%s pending %s must be triggered manually by calling %s.getBrowserSimulator().fireLoopEnd() before making your test assertions";
        String errorMessage = null;
        errorMessage = this.deferredScheduledCommands.size() > 0 ? String.format(format, this.deferredScheduledCommands.size(), "scheduledDeferred ScheduledCommand(s)", testName) : (this.entryScheduledCommands.size() > 0 ? String.format(format, this.entryScheduledCommands.size(), "scheduledEntry ScheduledCommand(s)", testName) : (this.entryRepeatingCommands.size() > 0 ? String.format(format, this.entryRepeatingCommands.size(), "scheduledEntry RepeatingCommand(s)", testName) : (this.finallyScheduledCommands.size() > 0 ? String.format(format, this.finallyRepeatingCommands.size(), "scheduledFinally ScheduledCommand(s)", testName) : (this.finallyRepeatingCommands.size() > 0 ? String.format(format, this.finallyRepeatingCommands.size(), "scheduledFinally RepeatingCommand(s)", testName) : String.format(format, this.asyncCallbackCommands.size(), "AsyncCallback", testName)))));
        this.clearPendingCommands();
        throw new GwtTestException(errorMessage);
    }

    public void clearPendingCommands() {
        this.deferredScheduledCommands.clear();
        this.entryScheduledCommands.clear();
        this.entryRepeatingCommands.clear();
        this.finallyScheduledCommands.clear();
        this.finallyRepeatingCommands.clear();
        this.asyncCallbackCommands.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireLoopEnd() {
        if (this.isTriggering) {
            return;
        }
        try {
            this.isTriggering = true;
            do {
                LinkedList<Scheduler.ScheduledCommand> deferredToExecuteInLoop = new LinkedList<Scheduler.ScheduledCommand>(this.deferredScheduledCommands);
                this.deferredScheduledCommands.clear();
                LinkedList<Command> asyncCallbackToExecuteInLoop = new LinkedList<Command>(this.asyncCallbackCommands);
                this.asyncCallbackCommands.clear();
                this.fireEventLoop(deferredToExecuteInLoop, asyncCallbackToExecuteInLoop);
            } while (this.entryRepeatingCommands.size() > 0 || this.finallyRepeatingCommands.size() > 0 || this.deferredScheduledCommands.size() > 0 || this.asyncCallbackCommands.size() > 0);
        }
        finally {
            this.isTriggering = false;
        }
    }

    public void recordAsyncCall(Command asyncCallbackCommand) {
        this.asyncCallbackCommands.add(asyncCallbackCommand);
    }

    public void scheduleDeferred(Scheduler.ScheduledCommand scheduledCommand) {
        this.deferredScheduledCommands.add(scheduledCommand);
    }

    public void scheduleEntry(Scheduler.RepeatingCommand repeatingCommand) {
        this.entryRepeatingCommands.add(repeatingCommand);
    }

    public void scheduleEntry(Scheduler.ScheduledCommand scheduledCommand) {
        this.entryScheduledCommands.add(scheduledCommand);
    }

    public void scheduleFinally(Scheduler.RepeatingCommand repeatingCommand) {
        this.finallyRepeatingCommands.add(repeatingCommand);
    }

    public void scheduleFinally(Scheduler.ScheduledCommand scheduledCommand) {
        this.finallyScheduledCommands.add(scheduledCommand);
    }

    private void executeReaptingCommnand(List<Scheduler.RepeatingCommand> commands) {
        ArrayList<Scheduler.RepeatingCommand> toRemove = new ArrayList<Scheduler.RepeatingCommand>();
        for (int i = 0; i < commands.size(); ++i) {
            Scheduler.RepeatingCommand current = commands.get(i);
            if (current.execute()) continue;
            toRemove.add(current);
        }
        for (Scheduler.RepeatingCommand rc : toRemove) {
            commands.remove(rc);
        }
    }

    private void fireEventLoop(Queue<Scheduler.ScheduledCommand> deferredToExecuteInLoop, Queue<Command> asyncCallbackToExecuteInLoop) {
        while (!this.finallyScheduledCommands.isEmpty()) {
            this.finallyScheduledCommands.poll().execute();
        }
        this.executeReaptingCommnand(this.finallyRepeatingCommands);
        while (!this.entryScheduledCommands.isEmpty()) {
            this.entryScheduledCommands.poll().execute();
        }
        this.executeReaptingCommnand(this.entryRepeatingCommands);
        while (!deferredToExecuteInLoop.isEmpty()) {
            deferredToExecuteInLoop.poll().execute();
        }
        while (!asyncCallbackToExecuteInLoop.isEmpty()) {
            asyncCallbackToExecuteInLoop.poll().execute();
        }
    }
}

