/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.SrcDirectoriesHolder;
import com.thoughtworks.paranamer.JavaFileParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtParanamer {
    private static final Paranamer INSTANCE = new JavaFileParanamer(new GwtTestJavaFileFinder());

    public static Paranamer get() {
        return INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GwtTestJavaFileFinder
    implements JavaFileParanamer.JavaFileFinder {
        private static final Logger LOGGER = LoggerFactory.getLogger(GwtTestJavaFileFinder.class);

        private GwtTestJavaFileFinder() {
        }

        @Override
        public InputStream openJavaFile(AccessibleObject methodOrConstructor) {
            Class<Object> declaringClass = null;
            if (methodOrConstructor instanceof Method) {
                declaringClass = ((Method)methodOrConstructor).getDeclaringClass();
            } else if (methodOrConstructor instanceof Constructor) {
                declaringClass = ((Constructor)methodOrConstructor).getDeclaringClass();
            } else {
                throw new UnsupportedOperationException("Not managed type : " + methodOrConstructor.getClass().getSimpleName());
            }
            return this.getInputStream(declaringClass);
        }

        private InputStream getInputStream(Class<?> declaringClass) {
            if (declaringClass.isMemberClass() || declaringClass.isLocalClass()) {
                declaringClass = declaringClass.getDeclaringClass();
            }
            String javaPath = declaringClass.getCanonicalName().replaceAll("\\.", "/") + ".java";
            InputStream is = declaringClass.getClassLoader().getResourceAsStream(javaPath);
            if (is != null) {
                return is;
            }
            for (String srcDirectory : SrcDirectoriesHolder.SRC_DIRECTORIES) {
                File root = new File(srcDirectory);
                File javaFile = new File(root, javaPath);
                if (!javaFile.exists()) continue;
                try {
                    return new FileInputStream(javaFile);
                }
                catch (Exception e) {
                    LOGGER.error("error while trying to retrieve java file corresponding to class " + declaringClass.getName() + ", deducted path is " + javaFile.getAbsolutePath(), (Throwable)e);
                }
            }
            throw new GwtTestConfigurationException("Cannot find the .java file which contains declaration of " + declaringClass.getName() + ". Did you forget to add your java source directory path by declaring a 'src-directory' property in your META-INF/gwt-test-utils.properties configuration file ? (example : src/main/java = src-directory)");
        }
    }
}

