/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.PotentialElement;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;

@PatchClass(value=PotentialElement.class)
class PotentialElementPatcher {
    private static final String POTENTIALELEMENT_TAG = "POTENTIALELEMENT_TAG";
    private static final String POTENTIALELEMENT_UIOBJECT = "POTENTIALELEMENT_UIOBJECT";
    private static final String POTENTIALELEMENT_WRAPPED_ELEMENT = "POTENTIALELEMENT_WRAPPED_ELEMENT";

    PotentialElementPatcher() {
    }

    @PatchMethod
    static PotentialElement build(UIObject o, String tagName) {
        PotentialElement e = (PotentialElement)JsoUtils.newNode(1).cast();
        Element wrappedElement = JsoUtils.newElement(tagName, o.getElement().getOwnerDocument());
        JavaScriptObjects.setProperty((JavaScriptObject)e, POTENTIALELEMENT_TAG, true);
        JavaScriptObjects.setProperty((JavaScriptObject)e, POTENTIALELEMENT_WRAPPED_ELEMENT, wrappedElement);
        JavaScriptObjects.setProperty((JavaScriptObject)e, POTENTIALELEMENT_UIOBJECT, o);
        return e;
    }

    @PatchMethod
    static void declareShim() {
    }

    @PatchMethod
    static boolean isPotential(JavaScriptObject o) {
        return JavaScriptObjects.getBoolean(o, POTENTIALELEMENT_TAG);
    }

    @PatchMethod
    static Element resolve(Element maybePotential) {
        if (PotentialElementPatcher.isPotential((JavaScriptObject)maybePotential)) {
            UIObject o = (UIObject)JavaScriptObjects.getObject((JavaScriptObject)maybePotential, POTENTIALELEMENT_UIOBJECT);
            GwtReflectionUtils.callPrivateMethod((Object)o, "resolvePotentialElement", new Object[0]);
            return (Element)JavaScriptObjects.getObject((JavaScriptObject)maybePotential, POTENTIALELEMENT_WRAPPED_ELEMENT);
        }
        return maybePotential;
    }

    @PatchMethod
    static Element setResolver(PotentialElement pe, UIObject resolver) {
        JavaScriptObjects.setProperty((JavaScriptObject)pe, POTENTIALELEMENT_UIOBJECT, resolver);
        return pe;
    }
}

