/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.TableCaptionElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(value=TableElement.class)
class TableElementPatcher {
    private static final String TCAPTION = "TCAPTION";
    private static final String TFOOT = "tFoot";
    private static final String THEAD = "tHead";

    TableElementPatcher() {
    }

    @PatchMethod
    static TableCaptionElement createCaption(TableElement e) {
        TableCaptionElement caption = (TableCaptionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TCAPTION);
        if (caption == null) {
            caption = Document.get().createCaptionElement();
            JavaScriptObjects.setProperty((JavaScriptObject)e, TCAPTION, caption);
            e.insertFirst((Node)caption);
        }
        return caption;
    }

    @PatchMethod
    static TableSectionElement createTFoot(TableElement e) {
        TableSectionElement tfoot = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TFOOT);
        if (tfoot == null) {
            tfoot = Document.get().createTFootElement();
            TableSectionElement thead = e.getTHead();
            if (thead != null) {
                e.insertAfter((Node)tfoot, (Node)thead);
            } else {
                TableCaptionElement caption = e.getCaption();
                if (caption == null) {
                    e.insertFirst((Node)tfoot);
                } else {
                    e.insertAfter((Node)tfoot, (Node)caption);
                }
            }
            JavaScriptObjects.setProperty((JavaScriptObject)e, TFOOT, tfoot);
        }
        return tfoot;
    }

    @PatchMethod
    static TableSectionElement createTHead(TableElement e) {
        TableSectionElement thead = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, THEAD);
        if (thead == null) {
            thead = Document.get().createTHeadElement();
            TableCaptionElement caption = e.getCaption();
            if (caption == null) {
                e.insertFirst((Node)thead);
            } else {
                e.insertAfter((Node)thead, (Node)caption);
            }
            JavaScriptObjects.setProperty((JavaScriptObject)e, THEAD, thead);
        }
        return thead;
    }

    @PatchMethod
    static void deleteCaption(TableElement e) {
        TableCaptionElement caption = (TableCaptionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TCAPTION);
        if (caption != null) {
            JavaScriptObjects.remove((JavaScriptObject)e, TCAPTION);
            e.removeChild((Node)caption);
        }
    }

    @PatchMethod
    static void deleteRow(TableElement e, int index) {
        NodeList rows = e.getRows();
        if (rows.getLength() < 1) {
            return;
        }
        if (index == -1) {
            index = rows.getLength() - 1;
        }
        TableRowElement rowToDelete = (TableRowElement)rows.getItem(index);
        e.removeChild((Node)rowToDelete);
    }

    @PatchMethod
    static void deleteTFoot(TableElement e) {
        TableSectionElement tfoot = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TFOOT);
        if (tfoot != null) {
            JavaScriptObjects.remove((JavaScriptObject)e, TFOOT);
            e.removeChild((Node)tfoot);
        }
    }

    @PatchMethod
    static void deleteTHead(TableElement e) {
        TableSectionElement thead = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, THEAD);
        if (thead != null) {
            JavaScriptObjects.remove((JavaScriptObject)e, THEAD);
            e.removeChild((Node)thead);
        }
    }

    @PatchMethod
    static TableCaptionElement getCaption(TableElement e) {
        return (TableCaptionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TCAPTION);
    }

    @PatchMethod
    static NodeList<TableRowElement> getRows(TableElement e) {
        return (NodeList)e.getElementsByTagName("tr").cast();
    }

    @PatchMethod
    static NodeList<TableSectionElement> getTBodies(TableElement e) {
        return (NodeList)TableElementPatcher.getElementByTagName(e, "tbody").cast();
    }

    @PatchMethod
    static TableSectionElement getTFoot(TableElement e) {
        return (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TFOOT);
    }

    @PatchMethod
    static TableSectionElement getTHead(TableElement e) {
        return (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, THEAD);
    }

    @PatchMethod
    static TableRowElement insertRow(TableElement e, int index) {
        NodeList rows = e.getRows();
        TableRowElement newRow = Document.get().createTRElement();
        if (rows.getLength() < 1) {
            TableSectionElement tbody = Document.get().createTBodyElement();
            e.appendChild((Node)tbody);
            tbody.appendChild((Node)newRow);
        } else if (index == -1 || index >= rows.getLength()) {
            TableRowElement after = (TableRowElement)rows.getItem(rows.getLength() - 1);
            after.getParentElement().insertAfter((Node)newRow, (Node)after);
        } else {
            TableRowElement before = (TableRowElement)rows.getItem(index);
            before.getParentElement().insertBefore((Node)newRow, (Node)before);
        }
        return newRow;
    }

    @PatchMethod
    static void setTFoot(TableElement e, TableSectionElement tFoot) {
        TableSectionElement old = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, TFOOT);
        if (old != null && tFoot != null) {
            e.replaceChild((Node)tFoot, (Node)old);
        } else if (tFoot != null) {
            e.appendChild((Node)tFoot);
        } else {
            e.removeChild((Node)old);
        }
        JavaScriptObjects.setProperty((JavaScriptObject)e, TFOOT, tFoot);
    }

    @PatchMethod
    static void setTHead(TableElement e, TableSectionElement tHead) {
        TableSectionElement old = (TableSectionElement)JavaScriptObjects.getObject((JavaScriptObject)e, THEAD);
        if (old != null && tHead != null) {
            e.replaceChild((Node)tHead, (Node)old);
        } else if (tHead != null) {
            e.appendChild((Node)tHead);
        } else {
            e.removeChild((Node)old);
        }
        JavaScriptObjects.setProperty((JavaScriptObject)e, THEAD, tHead);
    }

    private static NodeList<Element> getElementByTagName(TableElement e, String tagName) {
        NodeList childs = e.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Element childElement;
            Node n = childs.getItem(i);
            if (!Element.is((Node)n) || !tagName.equalsIgnoreCase((childElement = (Element)n.cast()).getTagName())) continue;
            list.add(childElement);
        }
        return JsoUtils.newNodeList(list);
    }
}

