/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(value=TableRowElement.class)
class TableRowElementPatcher {
    TableRowElementPatcher() {
    }

    @PatchMethod
    static void deleteCell(TableRowElement element, int index) {
        List<Node> innerList = JsoUtils.getChildNodeInnerList((Node)element);
        if (index == -1 || index >= innerList.size()) {
            index = innerList.size() - 1;
        }
        innerList.remove(index);
    }

    @PatchMethod
    static NodeList<TableCellElement> getCells(TableRowElement element) {
        return (NodeList)element.getChildNodes().cast();
    }

    @PatchMethod
    static int getSectionRowIndex(TableRowElement element) {
        if (element == null) {
            return -1;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return -1;
        }
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            if (!element.equals((Object)parent.getChildNodes().getItem(i))) continue;
            return i;
        }
        return -1;
    }

    @PatchMethod
    static TableCellElement insertCell(TableRowElement element, int index) {
        List<Node> innerList = JsoUtils.getChildNodeInnerList((Node)element);
        TableCellElement newCell = Document.get().createTDElement();
        if (index == -1 || index >= element.getCells().getLength()) {
            innerList.add((Node)newCell);
        } else {
            innerList.add(index, (Node)newCell);
        }
        return newCell;
    }
}

