/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.utils;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Text;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GwtHtmlContentHandler
implements ContentHandler {
    private Node currentNode;
    private final List<Node> nodes = new ArrayList<Node>();

    GwtHtmlContentHandler() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String string = String.valueOf(ch, start, length).replaceAll("\\u00A0", " ");
        if (string.length() > 0) {
            Text text = Document.get().createTextNode(string);
            if (this.currentNode != null) {
                this.currentNode.appendChild((Node)text);
            } else {
                this.nodes.add((Node)text);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public NodeList<Node> getParsedNodes() {
        return JsoUtils.newNodeList(this.nodes);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        Element element = Document.get().createElement(localName);
        if (this.currentNode != null) {
            this.currentNode.appendChild((Node)element);
        } else {
            this.nodes.add((Node)element);
        }
        this.currentNode = element;
        for (int index = 0; index < attributes.getLength(); ++index) {
            String attrName = attributes.getLocalName(index);
            String attrValue = attributes.getValue(index);
            if ("style".equalsIgnoreCase(attrName)) {
                GwtStyleUtils.overrideStyle(element.getStyle(), attrValue);
                continue;
            }
            if ("class".equalsIgnoreCase(attrName)) {
                element.setClassName(attrValue);
                continue;
            }
            element.setAttribute(attrName, attrValue);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String URI2) throws SAXException {
    }
}

