/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.utils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.Text;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.finder.GwtFinder;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.internal.utils.PropertyContainer;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsoUtils {
    private static final Set<String> DOM_PROPERTIES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("abbr");
            this.add("accept-charset");
            this.add("accept");
            this.add("accesskey");
            this.add("action");
            this.add("align");
            this.add("alink");
            this.add("alt");
            this.add("archive");
            this.add("axis");
            this.add("background");
            this.add("bgcolor");
            this.add("border");
            this.add("cellpadding");
            this.add("cellspacing");
            this.add("char");
            this.add("charoff");
            this.add("charset");
            this.add("checked");
            this.add("cite");
            this.add("class");
            this.add("classid");
            this.add("clear");
            this.add("code");
            this.add("codebase");
            this.add("codetype");
            this.add("color");
            this.add("cols");
            this.add("colspan");
            this.add("compact");
            this.add("content");
            this.add("coords");
            this.add("data");
            this.add("datetime");
            this.add("declare");
            this.add("defer");
            this.add("dir");
            this.add("disabled");
            this.add("enctype");
            this.add("face");
            this.add("for");
            this.add("frame");
            this.add("frameborder");
            this.add("headers");
            this.add("height");
            this.add("href");
            this.add("hreflang");
            this.add("hspace");
            this.add("http-equiv");
            this.add("id");
            this.add("ismap");
            this.add("label");
            this.add("lang");
            this.add("language");
            this.add("link");
            this.add("longdesc");
            this.add("marginheight");
            this.add("marginwidth");
            this.add("maxlength");
            this.add("media");
            this.add("method");
            this.add("multiple");
            this.add("name");
            this.add("nohref");
            this.add("noresize");
            this.add("noshade");
            this.add("nowrap");
            this.add("object");
            this.add("onblur");
            this.add("onchange");
            this.add("onclick");
            this.add("ondblclick");
            this.add("onfocus");
            this.add("onkeydown");
            this.add("onkeypress");
            this.add("onkeyup");
            this.add("onload");
            this.add("onmousedown");
            this.add("onmousemove");
            this.add("onmouseout");
            this.add("onmouseover");
            this.add("onmouseup");
            this.add("onreset");
            this.add("onselect");
            this.add("onsubmit");
            this.add("onunload");
            this.add("profile");
            this.add("prompt");
            this.add("readonly");
            this.add("rel");
            this.add("rev");
            this.add("rows");
            this.add("rowspan");
            this.add("rules");
            this.add("scheme");
            this.add("scope");
            this.add("scrolling");
            this.add("selected");
            this.add("shape");
            this.add("size");
            this.add("span");
            this.add("src");
            this.add("standby");
            this.add("start");
            this.add("style");
            this.add("summary");
            this.add("tabindex");
            this.add("target");
            this.add("text");
            this.add("title");
            this.add("type");
            this.add("usemap");
            this.add("valign");
            this.add("value");
            this.add("valuetype");
            this.add("version");
            this.add("vlink");
            this.add("vspace");
            this.add("width");
        }
    };
    private static final String ELEM_PROPERTIES = "ELEM_PROPERTIES";
    private static final String IS_XML_ELEMENT = "IS_XML_ELEMENT";
    private static final String NODE_LIST_FIELD = "childNodes";
    private static final String NODE_LIST_INNER_LIST = "NODE_LIST_INNER_LIST";
    private static final String NODE_NAME = "nodeName";
    private static final String NODE_TYPE_FIELD = "nodeType";
    private static final String PARENT_NODE_FIELD = "parentNode";
    private static final String TAG_NAME = "tagName";

    public static JavaScriptObject cloneJso(JavaScriptObject oldJso, boolean deep) {
        JavaScriptObject newJso = JavaScriptObject.createObject();
        if (Node.is((JavaScriptObject)oldJso)) {
            short nodeType = ((Node)oldJso.cast()).getNodeType();
            JavaScriptObjects.setProperty(newJso, NODE_TYPE_FIELD, nodeType);
        }
        for (Map.Entry<String, Object> entry : JavaScriptObjects.entrySet(oldJso)) {
            if (PARENT_NODE_FIELD.equals(entry.getKey()) || NODE_TYPE_FIELD.equals(entry.getKey())) continue;
            if ("NODE_OWNER_DOCUMENT".equals(entry.getKey())) {
                JavaScriptObjects.setProperty(newJso, "NODE_OWNER_DOCUMENT", JavaScriptObjects.getObject(oldJso, "NODE_OWNER_DOCUMENT"));
                continue;
            }
            if ("STYLE_OBJECT".equals(entry.getKey())) {
                Style newStyle = GwtStyleUtils.getStyle((Element)newJso.cast());
                GwtStyleUtils.cloneStyle(newStyle, (Style)entry.getValue());
                continue;
            }
            if (NODE_LIST_FIELD.equals(entry.getKey())) {
                Node newNode = (Node)newJso.cast();
                Node oldNode = (Node)oldJso.cast();
                JsoUtils.cloneChildNodes(newNode, oldNode, deep);
                continue;
            }
            if (ELEM_PROPERTIES.equals(entry.getKey())) {
                PropertyContainer newPc = JsoUtils.getDomProperties((Element)newJso.cast());
                PropertyContainer oldPc = JsoUtils.getDomProperties((Element)oldJso.cast());
                for (Map.Entry<String, Object> entry2 : oldPc.entrySet()) {
                    newPc.put(entry2.getKey(), entry2.getValue());
                }
                continue;
            }
            if (JavaScriptObject.class.isInstance(entry.getValue())) {
                JavaScriptObject oldChildJso = (JavaScriptObject)entry.getValue();
                JavaScriptObject newChildJso = JsoUtils.cloneJso(oldChildJso, deep);
                JavaScriptObjects.setProperty(newJso, entry.getKey(), newChildJso);
                continue;
            }
            JavaScriptObjects.setProperty(newJso, entry.getKey(), entry.getValue());
        }
        return newJso;
    }

    public static List<Node> getChildNodeInnerList(Node node) {
        NodeList<Node> nodeList = JsoUtils.getChildNodes(node);
        return (List)JavaScriptObjects.getObject(nodeList, NODE_LIST_INNER_LIST);
    }

    public static <T extends Node> List<T> getChildNodeInnerList(NodeList<T> nodeList) {
        assert (JsoUtils.isNodeList(nodeList)) : "not a NodeList";
        return (List)JavaScriptObjects.getObject(nodeList, NODE_LIST_INNER_LIST);
    }

    public static NodeList<Node> getChildNodes(Node node) {
        assert (Node.is((JavaScriptObject)node)) : "not a Node";
        NodeList nodeList = (NodeList)JavaScriptObjects.getObject((JavaScriptObject)node, NODE_LIST_FIELD);
        if (nodeList == null) {
            nodeList = JsoUtils.newNodeList();
            JavaScriptObjects.setProperty((JavaScriptObject)node, NODE_LIST_FIELD, nodeList);
        }
        return nodeList;
    }

    public static PropertyContainer getDomProperties(Element element) {
        assert (Node.is((JavaScriptObject)element)) : "not a Node";
        PropertyContainer pc = (PropertyContainer)JavaScriptObjects.getObject((JavaScriptObject)element, ELEM_PROPERTIES);
        if (pc == null) {
            pc = PropertyContainer.newInstance(new LinkedHashMap<String, Object>());
            JavaScriptObjects.setProperty((JavaScriptObject)element, ELEM_PROPERTIES, pc);
        }
        return pc;
    }

    public static short getNodeType(JavaScriptObject jso) {
        return JavaScriptObjects.hasProperty(jso, NODE_TYPE_FIELD) ? JavaScriptObjects.getShort(jso, NODE_TYPE_FIELD) : (short)-1;
    }

    public static String getTagName(Element element) {
        assert (Element.is((Node)element)) : "not an Element";
        return JavaScriptObjects.getString((JavaScriptObject)element, TAG_NAME);
    }

    public static boolean isNodeList(JavaScriptObject jso) {
        return JavaScriptObjects.hasProperty(jso, NODE_LIST_INNER_LIST);
    }

    public static boolean isStandardDOMProperty(String propertyName) {
        return "className".equals(propertyName) || !"class".equals(propertyName) && DOM_PROPERTIES.contains(propertyName);
    }

    public static boolean isXmlElement(JavaScriptObject jso) {
        return JavaScriptObjects.hasProperty(jso, IS_XML_ELEMENT);
    }

    public static Document newDocument() {
        Document document = (Document)JsoUtils.newNode(9).cast();
        JavaScriptObjects.setProperty((JavaScriptObject)document, "NODE_OWNER_DOCUMENT", document);
        return document;
    }

    public static Element newElement(String tag, Document ownerDocument) {
        Element elem = (Element)JsoUtils.newNode(1).cast();
        JavaScriptObjects.setProperty((JavaScriptObject)elem, TAG_NAME, tag);
        JavaScriptObjects.setProperty((JavaScriptObject)elem, "NODE_OWNER_DOCUMENT", ownerDocument);
        if (tag.equalsIgnoreCase("html")) {
            JavaScriptObjects.setProperty((JavaScriptObject)elem, NODE_NAME, "HTML");
        }
        return elem;
    }

    public static Node newNode(int nodeType) {
        Node newNode = (Node)JavaScriptObject.createObject().cast();
        JavaScriptObjects.setProperty((JavaScriptObject)newNode, NODE_TYPE_FIELD, (short)nodeType);
        return newNode;
    }

    public static <T extends Node> NodeList<T> newNodeList() {
        return JsoUtils.newNodeList(new ArrayList());
    }

    public static <T extends Node> NodeList<T> newNodeList(List<T> innerList) {
        NodeList nodeList = (NodeList)JavaScriptObject.createObject().cast();
        JavaScriptObjects.setProperty((JavaScriptObject)nodeList, NODE_LIST_INNER_LIST, innerList);
        return nodeList;
    }

    public static Text newText(String data, Document ownerDocument) {
        Text text = (Text)JsoUtils.newNode(3).cast();
        JavaScriptObjects.setProperty((JavaScriptObject)text, "NODE_OWNER_DOCUMENT", ownerDocument);
        text.setData(data);
        return text;
    }

    public static Element newXmlElement(Document document, String tagName) {
        Element xmlElement = document.createElement(tagName);
        JavaScriptObjects.setProperty((JavaScriptObject)xmlElement, IS_XML_ELEMENT, true);
        return xmlElement;
    }

    public static void onSetHTML(JavaScriptObject jso, String newHTML, String oldHTML) {
        EventListener listener = DOM.getEventListener((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)jso.cast()));
        if (UIObject.class.isInstance(listener)) {
            GwtReflectionUtils.callStaticMethod(GwtFinder.class, "onSetHTML", listener, newHTML, oldHTML);
        }
    }

    public static void onSetId(JavaScriptObject jso, String newId, String oldId) {
        EventListener listener = DOM.getEventListener((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)jso.cast()));
        if (UIObject.class.isInstance(listener)) {
            GwtReflectionUtils.callStaticMethod(GwtFinder.class, "onSetId", listener, newId, oldId);
        }
    }

    public static void onSetText(JavaScriptObject jso, String newText, String oldText) {
        EventListener listener = DOM.getEventListener((com.google.gwt.user.client.Element)((com.google.gwt.user.client.Element)jso.cast()));
        if (UIObject.class.isInstance(listener)) {
            GwtReflectionUtils.callStaticMethod(GwtFinder.class, "onSetText", listener, newText, oldText);
        }
    }

    public static String serialize(JavaScriptObject jso) {
        if (Node.is((JavaScriptObject)jso)) {
            return jso.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (Map.Entry<String, Object> entry : JavaScriptObjects.entrySet(jso)) {
            sb.append("\"").append(entry.getKey()).append("\": ");
            sb.append(entry.getValue()).append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        sb.append(" }");
        return sb.toString();
    }

    public static void setParentNode(Node child, Node parent) {
        JavaScriptObjects.setProperty((JavaScriptObject)child, PARENT_NODE_FIELD, parent);
    }

    private static void cloneChildNodes(Node newNode, Node oldNode, boolean deep) {
        List<Node> childs = JsoUtils.getChildNodeInnerList(oldNode);
        if (deep) {
            for (Node child : childs) {
                newNode.appendChild(child.cloneNode(deep));
            }
        } else {
            for (Node child : childs) {
                if (3 != child.getNodeType()) continue;
                newNode.appendChild((Node)Document.get().createTextNode(child.getNodeValue()));
                break;
            }
        }
    }
}

