/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.dom.client.Element;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.uibinder.DefaultUiWidgetTagFactory;
import com.googlecode.gwt.test.uibinder.UiBinderXmlUtils;
import com.googlecode.gwt.test.uibinder.UiElementTag;
import com.googlecode.gwt.test.uibinder.UiObjectTag;
import com.googlecode.gwt.test.uibinder.UiResourceManager;
import com.googlecode.gwt.test.uibinder.UiTag;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiTagBuilder<T> {
    private static final Pattern EXTERNAL_RESOURCES_PATTERN = Pattern.compile("\\s*\\{(\\S*)\\}\\s*");
    private UiTag<?> currentTag;
    private final Object owner;
    private final UiResourceManager resourceManager;
    private Object rootComponent;
    private final Class<T> rootComponentClass;

    static final <T> UiTagBuilder<T> create(Class<T> rootComponentClass, Object owner) {
        return new UiTagBuilder<T>(rootComponentClass, owner);
    }

    private UiTagBuilder(Class<T> rootComponentClass, Object owner) {
        this.rootComponentClass = rootComponentClass;
        this.owner = owner;
        this.resourceManager = UiResourceManager.newInstance(owner);
    }

    UiTagBuilder<T> appendText(String text) {
        if (!"".equals(text.trim())) {
            this.currentTag.appendText(text);
        }
        return this;
    }

    T build() {
        if (this.rootComponent == null) {
            if (this.currentTag == null) {
                throw new GwtTestUiBinderException(this.owner.getClass().getName() + " does not declare a root widget in its corresponding .ui.xml file");
            }
            throw new GwtTestUiBinderException("Cannot build UiBinder component while the parsing of '" + this.owner.getClass().getSimpleName() + ".ui.xml' is not finished");
        }
        if (!this.rootComponentClass.isInstance(this.rootComponent)) {
            throw new GwtTestUiBinderException("Error in '" + this.owner.getClass().getSimpleName() + ".ui.xml' configuration : root component is expected to be an instance of '" + this.rootComponentClass.getName() + "' but is actually an instance of '" + this.rootComponent.getClass().getName() + "'");
        }
        return (T)this.rootComponent;
    }

    UiTagBuilder<T> endTag(String nameSpaceURI, String localName) {
        if (UiBinderXmlUtils.isUiBinderTag(nameSpaceURI, localName)) {
            return this;
        }
        Object currentObject = this.currentTag.endTag();
        UiTag<?> parentTag = this.currentTag.getParentTag();
        this.currentTag = parentTag;
        if (UiBinderXmlUtils.isResourceTag(nameSpaceURI, localName) || UiBinderXmlUtils.isImportTag(nameSpaceURI, localName)) {
            return this;
        }
        if (UiBinderXmlUtils.isMsgTag(nameSpaceURI, localName) || UiBinderXmlUtils.isTextTag(nameSpaceURI, localName)) {
            parentTag.appendText((String)currentObject);
            return this;
        }
        if (parentTag == null) {
            if (this.rootComponent != null) {
                throw new GwtTestUiBinderException("UiBinder template '" + this.owner.getClass().getName() + "' should declare only one root widget in its corresponding .ui.xml file");
            }
            this.rootComponent = currentObject;
        } else if (IsWidget.class.isInstance(currentObject)) {
            parentTag.addWidget((IsWidget)currentObject);
        } else if (UIObject.class.isInstance(currentObject)) {
            parentTag.addUiObject((UIObject)currentObject);
        } else {
            parentTag.addElement((Element)currentObject);
        }
        return this;
    }

    UiTagBuilder<T> startTag(String nameSpaceURI, String localName, Attributes attributes) {
        if (UiBinderXmlUtils.isUiBinderTag(nameSpaceURI, localName)) {
            return this;
        }
        this.currentTag = this.createUiTag(nameSpaceURI, localName, attributes, this.currentTag);
        return this;
    }

    private UiTag<?> createUiTag(String nameSpaceURI, String localName, Attributes attributesXML, UiTag<?> parentTag) {
        Map<String, Object> attributes = this.parseAttributesMap(nameSpaceURI, attributesXML);
        localName = localName.replaceAll("\\.", "\\$");
        int i = nameSpaceURI.lastIndexOf(58);
        if (i > 0 && Character.isUpperCase(localName.charAt(0))) {
            String className = nameSpaceURI.substring(i + 1) + "." + localName;
            Class<?> clazz = null;
            try {
                clazz = GwtReflectionUtils.getClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new GwtTestUiBinderException("Cannot find class '" + className + "' declared in file '" + this.owner.getClass().getSimpleName() + ".ui.xml");
            }
            if (UIObject.class.isAssignableFrom(clazz) || IsWidget.class.isAssignableFrom(clazz)) {
                UiObjectTag<Object> uibinderTag = DefaultUiWidgetTagFactory.get().createUiObjectTag(clazz, attributes);
                uibinderTag.startTag(clazz, attributes, parentTag, this.owner);
                return uibinderTag;
            }
            throw new GwtTestUiBinderException("Not managed UiBinder type '" + clazz + "' declared in file '" + this.owner.getClass().getSimpleName() + ".ui.xml" + "', only implementation of '" + IsWidget.class.getName() + "' or subclass of '" + UIObject.class.getName() + "' are allowed");
        }
        if (UiBinderXmlUtils.isResourceTag(nameSpaceURI, localName)) {
            return this.resourceManager.registerResource(localName, attributes, parentTag, this.owner);
        }
        if (UiBinderXmlUtils.isImportTag(nameSpaceURI, localName)) {
            return this.resourceManager.registerImport(attributes, parentTag, this.owner);
        }
        if (UiBinderXmlUtils.isMsgTag(nameSpaceURI, localName)) {
            return this.resourceManager.registerMsg(attributes, parentTag, attributes);
        }
        if (UiBinderXmlUtils.isTextTag(nameSpaceURI, localName)) {
            return this.resourceManager.registerText(attributes, parentTag, attributes);
        }
        return new UiElementTag(nameSpaceURI, localName, attributes, parentTag, this.owner);
    }

    private Object extractResource(String group, UiResourceManager resourceManager, Object owner) {
        String[] splitted = group.split("\\.");
        String resourceAlias = splitted[0];
        Object resource = resourceManager.getUiResource(resourceAlias);
        if (resource == null) {
            throw new GwtTestUiBinderException("Error in file '" + owner.getClass().getSimpleName() + ".ui.xml' : no resource declared for alias '" + resourceAlias + "'");
        }
        if (splitted.length == 1) {
            return resource;
        }
        try {
            for (int i = 1; i < splitted.length; ++i) {
                if (CssResource.class.isInstance(resource)) {
                    return splitted[i];
                }
                resource = GwtReflectionUtils.callPrivateMethod(resource, splitted[i], new Object[0]);
            }
            return resource;
        }
        catch (Exception e) {
            if (GwtTestException.class.isInstance(e)) {
                throw (GwtTestException)e;
            }
            throw new GwtTestUiBinderException("Error while calling property '" + group.substring(group.indexOf(46) + 1) + "' on object of type '" + resourceManager.getUiResource(resourceAlias).getClass().getName() + "'", e);
        }
    }

    private String formatResourcesMessage(String attrValue, List<Object> resources) {
        StringBuilder sb = new StringBuilder();
        Matcher m = EXTERNAL_RESOURCES_PATTERN.matcher(attrValue);
        int foundNb = 0;
        int token = 0;
        while (m.find()) {
            sb.append(attrValue.substring(token, m.start(1))).append(foundNb++);
            token = m.end(1);
        }
        sb.append(attrValue.substring(token));
        return MessageFormat.format(sb.toString(), resources.toArray());
    }

    private Map<String, Object> parseAttributesMap(String elementNsURI, Attributes attributesXML) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        for (int i = 0; i < attributesXML.getLength(); ++i) {
            String attrUri;
            String attrName = attributesXML.getLocalName(i);
            String attrValue = attributesXML.getValue(i).trim();
            String string = attrUri = "".equals(attributesXML.getURI(i)) ? elementNsURI : attributesXML.getURI(i);
            if (UiBinderXmlUtils.isUiFieldAttribute(attrUri, attrName)) {
                attributesMap.put("ui:field", attrValue);
                continue;
            }
            if ("styleName".equals(attrName)) {
                attributesMap.put("styleName", UiBinderXmlUtils.getEffectiveStyleName(attrValue));
                continue;
            }
            if ("addStyleNames".equals(attrName)) {
                this.treatAddStyleNamesAttr(attrValue, attributesMap);
                continue;
            }
            this.treatStandardAttr(this.owner, this.resourceManager, attrName, attrValue, attributesMap);
        }
        return attributesMap;
    }

    private void treatAddStyleNamesAttr(String attrValue, Map<String, Object> attributesMap) {
        String[] styles = attrValue.trim().split(" ");
        String[] effectiveStyles = new String[styles.length];
        for (int j = 0; j < styles.length; ++j) {
            effectiveStyles[j] = UiBinderXmlUtils.getEffectiveStyleName(styles[j]);
        }
        attributesMap.put("addStyleNames", effectiveStyles);
    }

    private void treatStandardAttr(Object owner, UiResourceManager resourceManager, String attrName, String attrValue, Map<String, Object> attributesMap) {
        Matcher m = EXTERNAL_RESOURCES_PATTERN.matcher(attrValue);
        if (m.matches()) {
            attributesMap.put(attrName, this.extractResource(m.group(1), resourceManager, owner));
        } else {
            m = EXTERNAL_RESOURCES_PATTERN.matcher(attrValue);
            ArrayList<Object> resources = new ArrayList<Object>();
            while (m.find()) {
                resources.add(this.extractResource(m.group(1), resourceManager, owner));
            }
            if (resources.size() == 0) {
                attributesMap.put(attrName, attrValue);
            } else {
                attributesMap.put(attrName, this.formatResourcesMessage(attrValue, resources));
            }
        }
    }
}

