/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.web.MockHttpServletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String url;

    public MockRequestDispatcher(String url) {
        ((StringAssert)Assertions.assertThat((String)url).as("URL must not be null")).isNotNull();
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        ((ObjectAssert)Assertions.assertThat((Object)request).as("Request must not be null")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)response).as("Response must not be null")).isNotNull();
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: forwarding to URL [" + this.url + "]");
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        ((ObjectAssert)Assertions.assertThat((Object)request).as("Request must not be null")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)response).as("Response must not be null")).isNotNull();
        this.getMockHttpServletResponse(response).addIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockRequestDispatcher: including URL [" + this.url + "]");
        }
    }

    protected MockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

