/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.assertions;

import com.googlecode.gwt.test.assertions.GwtGenericAssert;
import com.googlecode.gwt.test.finder.GwtInstance;
import java.util.Arrays;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtInstanceAssert
extends GwtGenericAssert<GwtInstanceAssert, Object> {
    protected GwtInstanceAssert(GwtInstance instance) {
        super(instance.getRaw(), GwtInstanceAssert.class);
    }

    public GwtInstanceAssert isInstanceOf(Class<?> type) {
        this.assertNotNull();
        this.validateNotNull(type);
        Class<?> current = this.actual.getClass();
        if (type.isAssignableFrom(current)) {
            return this;
        }
        throw this.failWithMessage("expected instance of:<%s> but was instance of:<%s>", type, current);
    }

    public GwtInstanceAssert isInstanceOfAny(Class<?> ... types) {
        this.isNotNull();
        if (types == null) {
            throw new IllegalArgumentException("The given array of types should not be null");
        }
        if (!this.foundInstanceOfAny(types)) {
            throw this.failWithMessage("expected instance of any:<%s> but was instance of:<%s>", this.typeNames(types), this.actual.getClass().getName());
        }
        return this;
    }

    private void assertNotNull() {
        if (this.actual == null) {
            throw this.failWithMessage("expecting actual value not to be null", new Object[0]);
        }
    }

    private boolean foundInstanceOfAny(Class<?> ... types) {
        Class<?> current = this.actual.getClass();
        for (Class<?> type : types) {
            this.validateNotNull(type);
            if (!type.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    private String typeNames(Class<?> ... types) {
        return Arrays.toString(Objects.namesOf((Class[])types));
    }

    private void validateNotNull(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Expected type cannot be null");
        }
    }
}

