/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.finder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtInstance {
    private final String[] identifier;
    private final Object wrapped;

    protected GwtInstance(Object instance, String ... identifier) {
        this.identifier = identifier;
        this.wrapped = instance;
    }

    public final Object getRaw() {
        return this.wrapped;
    }

    public String identifierToString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.identifier) {
            sb.append("'").append(s).append("', ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public <T> T ofType(Class<T> type) throws IllegalArgumentException, NullPointerException, ClassCastException {
        this.validateNotNull(type);
        if (this.wrapped == null) {
            throw new NullPointerException("Object with identifier " + this.identifierToString() + " is null");
        }
        if (!type.isInstance(this.wrapped)) {
            throw new ClassCastException("Object of type " + this.wrapped.getClass().getName() + " with identifier " + this.identifierToString() + " cannot be cast to an instance of " + type.getName());
        }
        return (T)this.wrapped;
    }

    private void validateNotNull(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Expected type cannot be null");
        }
    }
}

