/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.gin;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.inject.client.GinModule;
import com.google.gwt.inject.client.GinModules;
import com.google.gwt.inject.client.Ginjector;
import com.google.gwt.inject.rebind.GinjectorBindings;
import com.google.gwt.inject.rebind.adapter.GinModuleAdapter;
import com.google.gwt.inject.rebind.util.GuiceUtil;
import com.google.gwt.inject.rebind.util.MemberCollector;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.GwtTreeLogger;
import com.googlecode.gwt.test.gin.DeferredBindingModule;
import com.googlecode.gwt.test.gin.GinInjectorInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GInjectorCreateHandler
implements GwtCreateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GInjectorCreateHandler.class);
    private Map<Class<? extends Ginjector>, Object> injectors;

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        Object guiceInjectorProxy;
        if (!Ginjector.class.isAssignableFrom(classLiteral)) {
            return null;
        }
        Class<?> ginjectorClass = classLiteral;
        if (this.injectors == null) {
            this.injectors = new HashMap<Class<? extends Ginjector>, Object>();
        }
        if ((guiceInjectorProxy = this.injectors.get(classLiteral)) != null) {
            LOGGER.debug("Proxy for class '" + ginjectorClass.getName() + "'has been found in cache. It is returned");
            return guiceInjectorProxy;
        }
        Class<? extends GinModule>[] ginModules = this.readGinModules(ginjectorClass);
        Set<Module> guiceModules = this.readGuiceModules(ginModules, ginjectorClass);
        DeferredBindingModule deferredBindingModule = DeferredBindingModule.getDeferredBindingModule(ginjectorClass, guiceModules);
        guiceModules.add((Module)deferredBindingModule);
        Injector injector = Guice.createInjector(guiceModules);
        LOGGER.debug("creating new Proxy for class '" + ginjectorClass.getName() + "'");
        guiceInjectorProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ginjectorClass}, (InvocationHandler)new GinInjectorInvocationHandler(injector));
        this.injectors.put(ginjectorClass, guiceInjectorProxy);
        return guiceInjectorProxy;
    }

    private Class<? extends GinModule>[] readGinModules(Class<? extends Ginjector> classLiteral) {
        LOGGER.debug("inspecting classLiteral " + classLiteral);
        GinModules annotation = classLiteral.getAnnotation(GinModules.class);
        if (annotation == null) {
            throw new IllegalArgumentException(classLiteral.getName() + " doesn't have any @GinModules annotation present");
        }
        Class[] ginModules = annotation.value();
        if (ginModules == null || ginModules.length == 0) {
            throw new IllegalArgumentException(classLiteral.getName() + " doesn't have any GinModules. " + "Runtime should not work.");
        }
        LOGGER.debug("discovered modules " + annotation);
        return ginModules;
    }

    private Set<Module> readGuiceModules(Class<? extends GinModule>[] classLiterals, Class<? extends Ginjector> ginectorClass) throws Exception {
        HashSet<Module> modules = new HashSet<Module>();
        for (Class<? extends GinModule> literal : classLiterals) {
            LOGGER.debug("wrapping GinModule literal " + literal);
            MemberCollector memberCollector = new MemberCollector((TreeLogger)GwtTreeLogger.get());
            GuiceUtil guiceUtil = new GuiceUtil(memberCollector);
            modules.add((Module)new GinModuleAdapter(literal.newInstance(), new GinjectorBindings(null, (TreeLogger)GwtTreeLogger.get(), guiceUtil, ginectorClass, null, memberCollector, null, null)));
        }
        return modules;
    }
}

