/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationStateBuilder;
import com.google.gwt.dev.javac.typemodel.TypeOracle;
import com.googlecode.gwt.test.GwtTreeLogger;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.CompilationStateClassLoader;
import com.googlecode.gwt.test.internal.ConfigurationLoader;
import com.googlecode.gwt.test.internal.GwtClassLoader;
import com.googlecode.gwt.test.internal.rewrite.OverlayTypesRewriter;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.regex.Pattern;

public class GwtFactory {
    private static GwtFactory instance;
    private static final Pattern SUREFIRE_BOOTER_JAR_PATTERN;
    private final CompilationState compilationState;
    private final ConfigurationLoader configurationLoader;
    private final GwtClassLoader gwtClassLoader;
    private final ModuleDef moduleDef;
    private final OverlayTypesRewriter overlayRewriter;
    private final URL surefireBooterJarUrl;

    public static GwtFactory get() {
        return instance;
    }

    public static boolean initializeIfNeeded() {
        URL currentSurefireBooterJarUrl = GwtFactory.findSureFireBooterJarUrl();
        if (instance == null) {
            instance = new GwtFactory(currentSurefireBooterJarUrl);
            return true;
        }
        if (GwtFactory.instance.surefireBooterJarUrl != null && !GwtFactory.instance.surefireBooterJarUrl.equals(currentSurefireBooterJarUrl) || GwtFactory.instance.surefireBooterJarUrl == null && currentSurefireBooterJarUrl != null) {
            instance = new GwtFactory(currentSurefireBooterJarUrl);
            return true;
        }
        return false;
    }

    private static URL findSureFireBooterJarUrl() {
        URL[] parentUrls;
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent instanceof URLClassLoader && (parentUrls = ((URLClassLoader)parent).getURLs()).length == 1 && SUREFIRE_BOOTER_JAR_PATTERN.matcher(parentUrls[0].getPath()).matches()) {
            return parentUrls[0];
        }
        return null;
    }

    private GwtFactory(URL surefireBooterJarUrl) {
        this.configurationLoader = new ConfigurationLoader(surefireBooterJarUrl);
        this.surefireBooterJarUrl = surefireBooterJarUrl;
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader();
        CompilationStateClassLoader tempCl = new CompilationStateClassLoader(defaultClassLoader, this.configurationLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)tempCl));
        try {
            this.moduleDef = this.createModuleDef(this.configurationLoader);
            this.compilationState = this.createCompilationState(this.moduleDef);
            this.overlayRewriter = this.createOverlayRewriter(this.compilationState);
            this.gwtClassLoader = GwtClassLoader.createClassLoader(this.configurationLoader, this.compilationState, this.overlayRewriter);
        }
        catch (UnableToCompleteException e) {
            GwtTreeLogger.get().onUnableToCompleteError();
            throw new GwtTestException("Error while generating gwt-test-utils prerequisites", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(defaultClassLoader);
        }
    }

    public GwtClassLoader getClassLoader() {
        return this.gwtClassLoader;
    }

    public CompilationState getCompilationState() {
        return this.compilationState;
    }

    public ConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    public ModuleDef getModuleDef() {
        return this.moduleDef;
    }

    public OverlayTypesRewriter getOverlayRewriter() {
        return this.overlayRewriter;
    }

    private CompilationState createCompilationState(ModuleDef moduleDef) throws UnableToCompleteException {
        GwtTreeLogger treeLogger = GwtTreeLogger.get();
        File target = new File("target");
        if (!target.exists()) {
            target = new File(".");
        }
        CompilationStateBuilder.init((TreeLogger)treeLogger, (File)target);
        return moduleDef.getCompilationState((TreeLogger)treeLogger);
    }

    private ModuleDef createModuleDef(ConfigurationLoader configurationLoader) throws UnableToCompleteException {
        List<String> gwtModules = configurationLoader.getGwtModules();
        String[] inherits = gwtModules.toArray(new String[gwtModules.size()]);
        return ModuleDefLoader.createSyntheticModule((TreeLogger)GwtTreeLogger.get(), (String)"com.googlecode.gwt.test.Aggregator", (String[])inherits, (boolean)false);
    }

    private OverlayTypesRewriter createOverlayRewriter(CompilationState compilationState) {
        TypeOracle typeOracle = compilationState.getTypeOracle();
        JClassType jsoType = typeOracle.findType("com.google.gwt.core.client.JavaScriptObject");
        return jsoType != null ? new OverlayTypesRewriter(compilationState, jsoType) : null;
    }

    static {
        SUREFIRE_BOOTER_JAR_PATTERN = Pattern.compile("^.*surefire.*\\.jar$");
    }
}

