/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.internal.Patcher;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;

public class GwtPatcherUtils {
    public static void patch(CtClass c, Patcher patcher) throws Exception {
        c.setModifiers(1);
        if (patcher != null) {
            patcher.initClass(c);
        }
        for (CtMethod m : c.getDeclaredMethods()) {
            boolean wasAbstract = false;
            String newBody = null;
            if (Modifier.isAbstract((int)m.getModifiers())) {
                m.setModifiers(m.getModifiers() - 1024);
                wasAbstract = true;
            }
            if (patcher != null) {
                newBody = patcher.getNewBody(m);
            }
            if (newBody != null) {
                if (Modifier.isNative((int)m.getModifiers())) {
                    m.setModifiers(m.getModifiers() - 256);
                }
                GwtPatcherUtils.replaceImplementation(m, newBody);
                continue;
            }
            if (!wasAbstract) continue;
            if (patcher != null) {
                m.setBody("{ throw new " + UnsupportedOperationException.class.getName() + "(\"Abstract method '" + c.getSimpleName() + "." + m.getName() + "()' is not patched by " + patcher.getClass().getName() + "\"); }");
                continue;
            }
            m.setBody("{ throw new " + UnsupportedOperationException.class.getName() + "(\"Abstract method '" + c.getSimpleName() + "." + m.getName() + "()' is not patched by any declared " + Patcher.class.getSimpleName() + " instance\"); }");
        }
        if (patcher != null) {
            patcher.finalizeClass(c);
        }
    }

    private static void replaceImplementation(CtMethod m, String src) throws Exception {
        if (src == null || src.trim().length() == 0) {
            m.setBody(null);
        } else {
            if (!(src = src.trim()).startsWith("{")) {
                src = !m.getReturnType().equals(CtClass.voidType) && !src.startsWith("return") ? "{ return ($r)($w) " + src : "{ " + src;
            }
            if (!src.endsWith("}")) {
                src = !src.endsWith(";") ? src + "; }" : src + " }";
            }
            try {
                m.setBody(src);
            }
            catch (CannotCompileException e) {
                throw new CannotCompileException("Unable to compile new body for method '" + m.getLongName() + "' : " + src, (Throwable)e);
            }
        }
    }

    private GwtPatcherUtils() {
    }
}

