/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.google.gwt.core.client.GWTBridge;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.GwtLogHandler;
import com.googlecode.gwt.test.GwtTreeLogger;
import com.googlecode.gwt.test.Mock;
import com.googlecode.gwt.test.exceptions.GwtTestDeferredBindingException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.GwtFactory;
import com.googlecode.gwt.test.internal.handlers.AnimationSchedulerCreateHandler;
import com.googlecode.gwt.test.internal.handlers.AutoBeanCreateHandler;
import com.googlecode.gwt.test.internal.handlers.CellBasedWidgetImplCreateHandler;
import com.googlecode.gwt.test.internal.handlers.DefaultGwtCreateHandler;
import com.googlecode.gwt.test.internal.handlers.DeferredReplaceWithCreateHandler;
import com.googlecode.gwt.test.internal.handlers.GeneratorCreateHandler;
import com.googlecode.gwt.test.internal.handlers.PlaceHistoryMapperCreateHandler;
import com.googlecode.gwt.test.internal.handlers.ResizeLayoutPanelImplCreateHandler;
import com.googlecode.gwt.test.internal.handlers.TestRemoteServiceCreateHandler;
import com.googlecode.gwt.test.internal.handlers.WebXmlRemoteServiceCreateHandler;
import com.googlecode.gwt.test.internal.i18n.LocalizableResourceCreateHandler;
import com.googlecode.gwt.test.internal.resources.ClientBundleCreateHandler;
import com.googlecode.gwt.test.internal.resources.ImageBundleCreateHandler;
import com.googlecode.gwt.test.uibinder.UiBinderCreateHandler;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtTestGWTBridge
extends GWTBridge
implements AfterTestCallback {
    private static final GwtTestGWTBridge INSTANCE = new GwtTestGWTBridge();
    private final List<GwtCreateHandler> addedHandlers;
    private final GwtCreateHandler animationSchedulerCreateHandler;
    private final GwtCreateHandler autoBeanCreateHandler;
    private final GwtCreateHandler cellBasedWidgetImplCreateHandler;
    private final GwtCreateHandler clientBundleCreateHander;
    private final GwtCreateHandler defaultGwtCreateHandler;
    private final GwtCreateHandler deferredReplaceWithCreateHandler;
    private final GwtCreateHandler generatorCreateHandler = new GeneratorCreateHandler(GwtFactory.get().getCompilationState(), GwtFactory.get().getModuleDef());
    private final GwtCreateHandler imageBundleCreateHandler;
    private final GwtCreateHandler localizableResourceCreateHandler;
    private GwtCreateHandler mockCreateHandler;
    private final GwtCreateHandler placeHistoryMapperCreateHandler;
    private final GwtCreateHandler resizeLayoutPanelImplCreateHandler;
    private final TestRemoteServiceCreateHandler testRemoteServiceCreateHandler;
    private final GwtCreateHandler uiBinderCreateHandler;
    private final WebXmlRemoteServiceCreateHandler webXmlRemoteServiceCreateHandler;

    public static GwtTestGWTBridge get() {
        return INSTANCE;
    }

    private GwtTestGWTBridge() {
        this.addedHandlers = new ArrayList<GwtCreateHandler>();
        this.animationSchedulerCreateHandler = new AnimationSchedulerCreateHandler();
        this.autoBeanCreateHandler = new AutoBeanCreateHandler();
        this.cellBasedWidgetImplCreateHandler = new CellBasedWidgetImplCreateHandler();
        this.clientBundleCreateHander = new ClientBundleCreateHandler();
        this.defaultGwtCreateHandler = new DefaultGwtCreateHandler();
        this.deferredReplaceWithCreateHandler = new DeferredReplaceWithCreateHandler();
        this.imageBundleCreateHandler = new ImageBundleCreateHandler();
        this.localizableResourceCreateHandler = new LocalizableResourceCreateHandler();
        this.placeHistoryMapperCreateHandler = new PlaceHistoryMapperCreateHandler();
        this.resizeLayoutPanelImplCreateHandler = new ResizeLayoutPanelImplCreateHandler();
        this.uiBinderCreateHandler = UiBinderCreateHandler.get();
        this.testRemoteServiceCreateHandler = TestRemoteServiceCreateHandler.get();
        this.webXmlRemoteServiceCreateHandler = new WebXmlRemoteServiceCreateHandler();
        AfterTestCallbackManager.get().registerCallback(this);
    }

    public void addGwtCreateHandler(GwtCreateHandler gwtCreateHandler) {
        this.addedHandlers.add(0, gwtCreateHandler);
    }

    @Override
    public void afterTest() throws Throwable {
        this.addedHandlers.clear();
        this.testRemoteServiceCreateHandler.reset();
        this.mockCreateHandler = null;
    }

    public <T> T create(Class<?> classLiteral) {
        for (GwtCreateHandler gwtCreateHandler : this.getGwtCreateHandlers()) {
            try {
                Object o = gwtCreateHandler.create(classLiteral);
                if (o == null) continue;
                return (T)o;
            }
            catch (GwtTestException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof UnableToCompleteException) {
                    GwtTreeLogger.get().onUnableToCompleteError();
                }
                throw new GwtTestPatchException("Error while creating instance of '" + classLiteral.getName() + "' through '" + gwtCreateHandler.getClass().getName() + "' instance", e);
            }
        }
        throw new GwtTestDeferredBindingException("No declared " + GwtCreateHandler.class.getSimpleName() + " has been able to create an instance of '" + classLiteral.getName() + "'. You should add our own with " + GwtConfig.get().getModuleRunner().getClass().getSimpleName() + ".addGwtCreateHandler(..) method or declared your tested object with @" + Mock.class.getSimpleName());
    }

    public String getVersion() {
        return "GWT by gwt-test-utils";
    }

    public boolean isClient() {
        return true;
    }

    public void log(String message, Throwable e) {
        GwtLogHandler logHandler = GwtConfig.get().getModuleRunner().getLogHandler();
        if (logHandler != null) {
            logHandler.log(message, e);
        }
    }

    public void setMockCreateHandler(GwtCreateHandler mockCreateHandler) {
        this.mockCreateHandler = mockCreateHandler;
    }

    private List<GwtCreateHandler> getGwtCreateHandlers() {
        ArrayList<GwtCreateHandler> list = new ArrayList<GwtCreateHandler>();
        if (this.mockCreateHandler != null) {
            list.add(this.mockCreateHandler);
        }
        list.addAll(this.addedHandlers);
        list.add(this.deferredReplaceWithCreateHandler);
        list.add(this.localizableResourceCreateHandler);
        list.add(this.clientBundleCreateHander);
        list.add(this.imageBundleCreateHandler);
        list.add(this.resizeLayoutPanelImplCreateHandler);
        list.add(this.uiBinderCreateHandler);
        list.add(this.testRemoteServiceCreateHandler);
        list.add(this.webXmlRemoteServiceCreateHandler);
        list.add(this.cellBasedWidgetImplCreateHandler);
        list.add(this.animationSchedulerCreateHandler);
        list.add(this.placeHistoryMapperCreateHandler);
        list.add(this.autoBeanCreateHandler);
        list.add(this.defaultGwtCreateHandler);
        list.add(this.generatorCreateHandler);
        return list;
    }
}

