/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.junit;

import com.googlecode.gwt.test.internal.GwtFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGwtRunnerFactory {
    private static boolean hasJUnit45OrHigher;
    private static boolean hasJUnitParams;

    public Runner create(Class<?> clazz) throws Throwable {
        try {
            String runnerClassName = this.getRunnerClassName(hasJUnit45OrHigher, hasJUnitParams);
            return this.newInstance(runnerClassName, clazz);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected abstract String getRunnerClassName(boolean var1, boolean var2);

    private Runner newInstance(String runnerClassName, Class<?> constructorParam) throws Exception {
        Class runnerClass = GwtFactory.get().getClassLoader().loadClass(runnerClassName);
        Class testedClass = GwtFactory.get().getClassLoader().loadClass(constructorParam.getName());
        Constructor constructor = runnerClass.getConstructor(Class.class.getClass());
        return (Runner)constructor.newInstance(testedClass);
    }

    static {
        try {
            Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
            hasJUnit45OrHigher = true;
        }
        catch (Throwable t) {
            hasJUnit45OrHigher = false;
        }
        try {
            Class.forName("junitparams.JUnitParamsRunner");
            hasJUnitParams = true;
        }
        catch (Throwable t) {
            hasJUnitParams = false;
        }
    }
}

