/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.impl.HistoryImpl;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.ArrayList;
import java.util.List;

@PatchClass(value=HistoryImpl.class)
class HistoryImplPatcher {
    static GwtBrowserHistory BROWSER_HISTORY = new GwtBrowserHistory();

    HistoryImplPatcher() {
    }

    @PatchMethod
    static String encodeFragment(HistoryImpl impl, String fragment) {
        return URL.encodeQueryString((String)fragment).replace("#", "%23");
    }

    @PatchMethod
    static String getToken() {
        return BROWSER_HISTORY.getCurrentToken();
    }

    @PatchMethod
    static boolean init(HistoryImpl historyImpl) {
        String hash = Window.Location.getHash();
        int index = hash.indexOf("#");
        if (index > -1) {
            String token = hash.substring(index + 1);
            GwtReflectionUtils.callPrivateMethod((Object)historyImpl, "setToken", token);
            HistoryImplPatcher.nativeUpdate(historyImpl, token);
        }
        return true;
    }

    @PatchMethod
    static void nativeUpdate(HistoryImpl historyImpl, String historyToken) {
        if (historyToken == null) {
            historyToken = "";
        }
        BROWSER_HISTORY.addToken(historyToken);
    }

    static class GwtBrowserHistory
    implements AfterTestCallback {
        private int currentIndex = -1;
        private final List<String> stack = new ArrayList<String>();

        GwtBrowserHistory() {
            AfterTestCallbackManager.get().registerCallback(this);
        }

        public void addToken(String token) {
            String current = this.getCurrentToken();
            if (!current.equals(token)) {
                while (this.stack.size() > this.currentIndex + 1) {
                    this.stack.remove(this.stack.size() - 1);
                }
                this.stack.add(token);
                this.currentIndex = this.stack.size() - 1;
            }
        }

        public void afterTest() throws Throwable {
            this.stack.clear();
            this.currentIndex = -1;
            HistoryImpl historyImpl = (HistoryImpl)GwtReflectionUtils.getStaticFieldValue(History.class, "impl");
            GwtReflectionUtils.callPrivateMethod(GwtReflectionUtils.getPrivateFieldValue(GwtReflectionUtils.getPrivateFieldValue(GwtReflectionUtils.getPrivateFieldValue((Object)historyImpl, "handlers"), "eventBus"), "map"), "clear", new Object[0]);
        }

        public String back() {
            String token = null;
            boolean fireEvent = false;
            switch (this.currentIndex) {
                case 0: {
                    --this.currentIndex;
                    fireEvent = true;
                }
                case -1: {
                    token = "";
                    break;
                }
                default: {
                    fireEvent = true;
                    token = this.stack.get(--this.currentIndex);
                }
            }
            if (fireEvent) {
                this.fireHistoryChanged(token);
            }
            return token;
        }

        public String forward() {
            if (this.currentIndex >= this.stack.size() - 1) {
                return "";
            }
            String token = this.stack.get(++this.currentIndex);
            this.fireHistoryChanged(token);
            return token;
        }

        public String getCurrentToken() {
            return this.currentIndex == -1 ? "" : this.stack.get(this.currentIndex);
        }

        private void fireHistoryChanged(String token) {
            HistoryImpl impl = (HistoryImpl)GwtReflectionUtils.getStaticFieldValue(History.class, "impl");
            impl.fireHistoryChangedImpl(token);
        }
    }
}

