/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers.dom;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Text;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.exceptions.GwtTestDomException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.utils.DoubleMap;
import com.googlecode.gwt.test.internal.utils.GwtHtmlParser;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(value=Document.class)
class DocumentPatcher {
    private static final String DOCUMENT_ELEMENT = "documentElement";
    private static DocumentHolder DOCUMENT_HOLDER = new DocumentHolder();
    private static final String EMPTY_HTML = "<html><head></head><body></body></html>";
    private static final DoubleMap<String, String, String> HTML_ELEMENT_PROTOTYPES = new DoubleMap();
    private static int ID = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentPatcher.class);

    DocumentPatcher() {
    }

    @PatchMethod
    static Text createTextNode(Document document, String data) {
        return JsoUtils.newText(data, document);
    }

    @PatchMethod
    static String createUniqueId(Document document) {
        return "elem_" + Long.toString(++ID);
    }

    @PatchMethod
    static BodyElement getBody(Document document) {
        NodeList<Element> bodyList = DocumentPatcher.getElementsByTagName((Node)document, "body");
        if (bodyList.getLength() < 1) {
            return null;
        }
        return (BodyElement)((Element)bodyList.getItem(0)).cast();
    }

    @PatchMethod
    static String getCompatMode(Document document) {
        return "toto";
    }

    @PatchMethod
    static String getDomain(Document document) {
        return null;
    }

    @PatchMethod
    static Element getElementById(Node document, String elementId) {
        List<Node> childs = JsoUtils.getChildNodeInnerList(document);
        for (Node n : childs) {
            Element currentElement;
            if (1 == n.getNodeType() && elementId.equals((currentElement = (Element)n.cast()).getId())) {
                return currentElement;
            }
            Element result = DocumentPatcher.getElementById(n, elementId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @PatchMethod
    static NodeList<Element> getElementsByTagName(Node node, String tagName) {
        ArrayList<Element> result = new ArrayList<Element>();
        DocumentPatcher.inspectDomForTag(node, tagName, result);
        return JsoUtils.newNodeList(result);
    }

    @PatchMethod
    static String getReferrer(Document document) {
        return "";
    }

    @PatchMethod
    static Document nativeGet() {
        if (DOCUMENT_HOLDER.document == null) {
            try {
                DOCUMENT_HOLDER.document = JsoUtils.newDocument();
                Element e = DocumentPatcher.parseHTMLElement(DOCUMENT_HOLDER.document);
                DOCUMENT_HOLDER.document.appendChild((Node)e);
                JavaScriptObjects.setProperty((JavaScriptObject)DOCUMENT_HOLDER.document, DOCUMENT_ELEMENT, e);
                return DOCUMENT_HOLDER.document;
            }
            catch (Exception e) {
                if (GwtTestException.class.isInstance(e)) {
                    throw (GwtTestException)e;
                }
                throw new GwtTestDomException("Unable to create Document", e);
            }
        }
        return DOCUMENT_HOLDER.document;
    }

    private static Element findHTMLElement(NodeList<Node> nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            Node node = nodes.getItem(i);
            if (1 != node.getNodeType() || !"html".equalsIgnoreCase((e = (Element)node.cast()).getTagName())) continue;
            return e;
        }
        return null;
    }

    private static String getHostPageHTML(String hostPagePath) {
        InputStream is = JavaScriptObjects.class.getClassLoader().getResourceAsStream(hostPagePath);
        if (is == null) {
            try {
                is = new FileInputStream(hostPagePath);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (is == null) {
            LOGGER.warn("Cannot find the host HTML file '" + hostPagePath + "', fallback to an empty HTML document instead. You may want to override " + GwtConfig.get().getModuleRunner().getClass().getSimpleName() + ".getHostPagePath(String moduleFullQualifiedName) method to specify the relative path of the your HTML file from the root directory of your java project");
            return EMPTY_HTML;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new GwtTestConfigurationException("Error while reading module HTML host page '" + hostPagePath + "'", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void inspectDomForTag(Node node, String tagName, List<Element> result) {
        List<Node> childs = JsoUtils.getChildNodeInnerList(node);
        for (Node n : childs) {
            if (1 == n.getNodeType()) {
                Element childElem = (Element)n.cast();
                if ("*".equals(tagName) || tagName.equalsIgnoreCase(childElem.getTagName())) {
                    result.add(childElem);
                }
            }
            DocumentPatcher.inspectDomForTag(n, tagName, result);
        }
    }

    private static Element parseHTMLElement(Document document) {
        NodeList<Node> list;
        Element htmlElement;
        String moduleName = GwtConfig.get().getModuleAlias();
        String hostPagePath = GwtConfig.get().getModuleRunner().getHostPagePath();
        if (hostPagePath == null) {
            Element defaultHTMLElement = JsoUtils.newElement("HTML", document);
            defaultHTMLElement.appendChild((Node)JsoUtils.newElement("body", document));
            return defaultHTMLElement;
        }
        String html = HTML_ELEMENT_PROTOTYPES.get(moduleName, hostPagePath);
        if (html == null) {
            html = DocumentPatcher.getHostPageHTML(hostPagePath);
            HTML_ELEMENT_PROTOTYPES.put(moduleName, hostPagePath, html);
        }
        if ((htmlElement = DocumentPatcher.findHTMLElement(list = GwtHtmlParser.parse(html))) == null) {
            throw new GwtTestDomException("Cannot find a root <html> element in file '" + hostPagePath + "'");
        }
        return htmlElement;
    }

    private static class DocumentHolder
    implements AfterTestCallback {
        private Document document;

        private DocumentHolder() {
            AfterTestCallbackManager.get().registerFinalCallback(this);
        }

        public void afterTest() throws Throwable {
            this.document = null;
            Class<?> documentClass = Class.forName("com.google.gwt.dom.client.Document$");
            GwtReflectionUtils.setStaticField(documentClass, "doc", null);
        }
    }
}

