/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.google.gwt.dom.client.StyleInjector;
import com.googlecode.gwt.test.internal.resources.CssResourceReader;
import com.googlecode.gwt.test.internal.resources.ResourcePrototypeCallback;
import com.googlecode.gwt.test.internal.resources.TextResourceReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CssResourceCallback
implements ResourcePrototypeCallback {
    private boolean alreadyInjected = false;
    private final CssReader cssReader;

    CssResourceCallback(final List<URL> resourceURLs) {
        this.cssReader = new CssReader(){

            public CssResourceReader.CssParsingResult readCss() throws Exception {
                return CssResourceReader.get().readCss(resourceURLs);
            }

            public String readCssText() throws Exception {
                return TextResourceReader.get().readFiles(resourceURLs);
            }
        };
    }

    CssResourceCallback(final String text) {
        this.cssReader = new CssReader(){

            public CssResourceReader.CssParsingResult readCss() throws Exception {
                return CssResourceReader.get().readCss(text);
            }

            public String readCssText() throws Exception {
                return text;
            }
        };
    }

    @Override
    public Object call(Method method, Object[] args) throws Exception {
        if (method.getName().equals("getText")) {
            return this.cssReader.readCssText();
        }
        if (method.getName().equals("ensureInjected")) {
            return this.ensureInjected();
        }
        return this.handleCustomMethod(method.getName());
    }

    private boolean ensureInjected() throws Exception {
        if (!this.alreadyInjected) {
            StyleInjector.inject((String)this.cssReader.readCssText());
            this.alreadyInjected = true;
            return true;
        }
        return false;
    }

    private String handleCustomMethod(String methodName) throws Exception {
        CssResourceReader.CssParsingResult result = this.cssReader.readCss();
        String constant = result.getConstantValue(methodName);
        if (constant != null) {
            return constant;
        }
        return methodName;
    }

    private static interface CssReader {
        public CssResourceReader.CssParsingResult readCss() throws Exception;

        public String readCssText() throws Exception;
    }
}

