/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.rewrite;

import com.google.gwt.core.client.GwtScriptOnly;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.asm.ClassReader;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.ClassWriter;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.googlecode.gwt.test.GwtTreeLogger;
import com.googlecode.gwt.test.internal.rewrite.ForceClassVersion15;
import com.googlecode.gwt.test.internal.rewrite.RewriteRefsToJsoClasses;
import com.googlecode.gwt.test.internal.rewrite.RewriteSingleJsoImplDispatches;
import com.googlecode.gwt.test.internal.rewrite.UseMirroredClasses;
import com.googlecode.gwt.test.internal.rewrite.WriteJsoImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class OverlayTypesRewriter {
    static final String JAVASCRIPTOBJECT_DESC = "com.google.gwt.core.client.JavaScriptObject".replace('.', '/');
    static final String JAVASCRIPTOBJECT_IMPL_DESC = "com.google.gwt.core.client.JavaScriptObject$".replace('.', '/');
    private final CompilationState compilationState;
    private final HostedModeClassRewriter.SingleJsoImplData jsoData;
    private final Set<String> jsoImplDescs;
    private final Set<String> jsoIntfDescs;
    private final Map<String, List<String>> jsoSuperDescs;
    private final HostedModeClassRewriter.InstanceMethodOracle mapper;
    private final Set<String> singleJsoImplTypes = new HashSet<String>();
    private final TypeOracle typeOracle;

    static String addSyntheticThisParam(String owner, String methodDescriptor) {
        return "(L" + owner + ";" + methodDescriptor.substring(1);
    }

    private static JClassType findImplementingTypeForMethod(JClassType type, JMethod method) {
        JType[] methodParamTypes = method.getErasedParameterTypes();
        while (type != null) {
            for (JMethod candidate : type.getMethods()) {
                if (!OverlayTypesRewriter.hasMatchingErasedSignature(method, methodParamTypes, candidate)) continue;
                return type;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private static boolean hasMatchingErasedSignature(JMethod a, JType[] aParamTypes, JMethod b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        JType[] bParamTypes = b.getErasedParameterTypes();
        if (aParamTypes.length != bParamTypes.length) {
            return false;
        }
        for (int i = 0; i < aParamTypes.length; ++i) {
            if (aParamTypes[i] == bParamTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static String toDescriptor(String jsoSubtype) {
        return jsoSubtype.replace('.', '/');
    }

    public OverlayTypesRewriter(CompilationState compilationState, JClassType jsoType) {
        HashSet<JClassType> jsoTypes = new HashSet<JClassType>();
        JClassType[] jsoSubtypes = jsoType.getSubtypes();
        Collections.addAll(jsoTypes, jsoSubtypes);
        jsoTypes.add(jsoType);
        HashSet<String> jsoTypeNames = new HashSet<String>();
        HashMap jsoSuperTypes = new HashMap();
        for (JClassType type : jsoTypes) {
            ArrayList<String> types = new ArrayList<String>();
            types.add(this.getBinaryName(type.getSuperclass()));
            for (JClassType impl : type.getImplementedInterfaces()) {
                types.add(this.getBinaryName(impl));
            }
            String binaryName = this.getBinaryName(type);
            jsoTypeNames.add(binaryName);
            jsoSuperTypes.put(binaryName, types);
        }
        HashSet<String> buildJsoIntfDescs = new HashSet<String>();
        HashSet<String> buildJsoImplDescs = new HashSet<String>();
        HashMap buildJsoSuperDescs = new HashMap();
        for (String jsoSubtype : jsoTypeNames) {
            String desc = OverlayTypesRewriter.toDescriptor(jsoSubtype);
            buildJsoIntfDescs.add(desc);
            buildJsoImplDescs.add(desc + "$");
            List superTypes = (List)jsoSuperTypes.get(jsoSubtype);
            assert (superTypes != null);
            assert (superTypes.size() > 0);
            ListIterator<String> i = superTypes.listIterator();
            while (i.hasNext()) {
                i.set(OverlayTypesRewriter.toDescriptor((String)i.next()));
            }
            buildJsoSuperDescs.put(desc, Collections.unmodifiableList(superTypes));
        }
        String notJsoDesc = OverlayTypesRewriter.toDescriptor("com.google.gwt.regexp.shared.RegExp");
        buildJsoIntfDescs.remove(notJsoDesc);
        buildJsoImplDescs.remove(notJsoDesc);
        buildJsoSuperDescs.remove(notJsoDesc);
        notJsoDesc = OverlayTypesRewriter.toDescriptor("com.google.gwt.regexp.shared.MatchResult");
        buildJsoIntfDescs.remove(notJsoDesc);
        buildJsoImplDescs.remove(notJsoDesc);
        buildJsoSuperDescs.remove(notJsoDesc);
        notJsoDesc = OverlayTypesRewriter.toDescriptor("com.google.gwt.regexp.shared.SplitResult");
        buildJsoIntfDescs.remove(notJsoDesc);
        buildJsoImplDescs.remove(notJsoDesc);
        buildJsoSuperDescs.remove(notJsoDesc);
        this.compilationState = compilationState;
        this.typeOracle = compilationState.getTypeOracle();
        this.jsoIntfDescs = Collections.unmodifiableSet(buildJsoIntfDescs);
        this.jsoImplDescs = Collections.unmodifiableSet(buildJsoImplDescs);
        this.jsoSuperDescs = Collections.unmodifiableMap(buildJsoSuperDescs);
        this.jsoData = new MySingleJsoImplData(this.typeOracle);
        this.mapper = new MyInstanceMethodOracle(jsoTypes, this.typeOracle.getJavaLangObject());
    }

    public String canonicalizeClassName(String className) {
        String lookupClassName = className.replace('.', '/');
        if (this.isJsoImpl(className)) {
            lookupClassName = lookupClassName.substring(0, lookupClassName.length() - 1);
        }
        return lookupClassName;
    }

    public CompilationState getCompilationState() {
        return this.compilationState;
    }

    public boolean isJsoImpl(String className) {
        return this.jsoImplDescs.contains(OverlayTypesRewriter.toDescriptor(className));
    }

    public boolean isJsoIntf(String className) {
        return this.jsoIntfDescs.contains(OverlayTypesRewriter.toDescriptor(className));
    }

    public byte[] rewrite(String className, byte[] classBytes) {
        ClassWriter writer;
        SpeedTracerLogger.Event classBytesRewriteEvent = SpeedTracerLogger.start((SpeedTracerLogger.EventType)DevModeEventType.CLASS_BYTES_REWRITE, (String[])new String[]{"Class Name", className});
        String desc = OverlayTypesRewriter.toDescriptor(className);
        assert (!this.jsoIntfDescs.contains(desc));
        Object v = writer = new ClassWriter(0);
        v = new UseMirroredClasses((ClassVisitor)v, className);
        v = new RewriteSingleJsoImplDispatches((ClassVisitor)v, this.typeOracle, this.jsoData);
        v = new RewriteRefsToJsoClasses((ClassVisitor)v, this.jsoIntfDescs, this.mapper);
        if (this.jsoImplDescs.contains(desc)) {
            v = WriteJsoImpl.create((ClassVisitor)v, desc, this.jsoIntfDescs, this.mapper, this.jsoData);
        }
        if (Double.parseDouble(System.getProperty("java.class.version")) < 50.0) {
            v = new ForceClassVersion15((ClassVisitor)v);
        }
        new ClassReader(classBytes).accept((ClassVisitor)v, 0);
        classBytesRewriteEvent.end(new String[0]);
        return writer.toByteArray();
    }

    public byte[] writeJsoIntf(String className) {
        ClassWriter writer;
        String desc = OverlayTypesRewriter.toDescriptor(className);
        assert (this.jsoIntfDescs.contains(desc));
        assert (this.jsoSuperDescs.containsKey(desc));
        List<String> superDescs = this.jsoSuperDescs.get(desc);
        assert (superDescs != null);
        assert (superDescs.size() > 0);
        ClassWriter v = writer = new ClassWriter(0);
        String[] interfaces = superDescs.contains("java/lang/Object") ? null : superDescs.toArray(new String[superDescs.size()]);
        v.visit(49, 513, desc, null, "java/lang/Object", interfaces);
        v.visitEnd();
        return writer.toByteArray();
    }

    private String getBinaryName(JClassType type) {
        String name = type.getPackage().getName() + '.';
        name = name + type.getName().replace('.', '$');
        return name;
    }

    private String getBinaryOrPrimitiveName(JType type) {
        JArrayType asArray = type.isArray();
        JClassType asClass = type.isClassOrInterface();
        JPrimitiveType asPrimitive = type.isPrimitive();
        if (asClass != null) {
            return this.getBinaryName(asClass);
        }
        if (asPrimitive != null) {
            return asPrimitive.getQualifiedSourceName();
        }
        if (asArray != null) {
            JType componentType = asArray.getComponentType();
            return this.getBinaryOrPrimitiveName(componentType) + "[]";
        }
        throw new InternalCompilerException("Cannot create binary name for " + type.getQualifiedSourceName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MySingleJsoImplData
    implements HostedModeClassRewriter.SingleJsoImplData {
        private final SortedSet<String> mangledNames = new TreeSet<String>();
        private final Map<String, List<Method>> mangledNamesToDeclarations = new HashMap<String, List<Method>>();
        private final Map<String, List<Method>> mangledNamesToImplementations = new HashMap<String, List<Method>>();
        private final Set<String> unmodifiableIntfNames = Collections.unmodifiableSet(OverlayTypesRewriter.access$300(OverlayTypesRewriter.this));
        private final SortedSet<String> unmodifiableNames = Collections.unmodifiableSortedSet(this.mangledNames);

        public MySingleJsoImplData(TypeOracle typeOracle) {
            block0: for (JClassType type : typeOracle.getSingleJsoImplInterfaces()) {
                assert (type.isInterface() == type) : "Expecting interfaces only";
                for (JMethod intfMethod : type.getOverridableMethods()) {
                    JMethod implementingMethod;
                    assert (intfMethod.isAbstract()) : "Expecting only abstract methods";
                    JClassType implementingType = typeOracle.getSingleJsoImpl(intfMethod.getEnclosingType());
                    if (implementingType == null || implementingType.isAnnotationPresent(GwtScriptOnly.class)) continue block0;
                    OverlayTypesRewriter.this.singleJsoImplTypes.add(OverlayTypesRewriter.this.canonicalizeClassName(OverlayTypesRewriter.this.getBinaryName(type)));
                    String mangledName = OverlayTypesRewriter.this.getBinaryName(type).replace('.', '_') + "_" + intfMethod.getName();
                    this.mangledNames.add(mangledName);
                    while ((implementingMethod = this.findOverloadUsingErasure(implementingType, intfMethod)) == null) {
                        implementingType = implementingType.getSuperclass();
                    }
                    String decl = OverlayTypesRewriter.this.getBinaryOrPrimitiveName(intfMethod.getReturnType().getErasedType()) + " " + intfMethod.getName() + "(";
                    for (JParameter param : intfMethod.getParameters()) {
                        decl = decl + ",";
                        decl = decl + OverlayTypesRewriter.this.getBinaryOrPrimitiveName(param.getType().getErasedType());
                    }
                    decl = decl + ")";
                    Method declaration = Method.getMethod((String)decl);
                    this.addToMap(this.mangledNamesToDeclarations, mangledName, declaration);
                    String returnName = OverlayTypesRewriter.this.getBinaryOrPrimitiveName(implementingMethod.getReturnType().getErasedType());
                    String jsoName = OverlayTypesRewriter.this.getBinaryOrPrimitiveName((JType)implementingType);
                    String decl2 = returnName + " " + intfMethod.getName() + "$ (" + jsoName;
                    for (JParameter param : implementingMethod.getParameters()) {
                        decl2 = decl2 + ",";
                        decl2 = decl2 + OverlayTypesRewriter.this.getBinaryOrPrimitiveName(param.getType().getErasedType());
                    }
                    decl2 = decl2 + ")";
                    Method toImplement = Method.getMethod((String)decl2);
                    this.addToMap(this.mangledNamesToImplementations, mangledName, toImplement);
                }
            }
            GwtTreeLogger logger = GwtTreeLogger.get();
            if (logger.isLoggable(TreeLogger.SPAM)) {
                TreeLogger dumpLogger = logger.branch(TreeLogger.SPAM, "SingleJsoImpl method mappings");
                for (Map.Entry<String, List<Method>> entry : this.mangledNamesToImplementations.entrySet()) {
                    dumpLogger.log(TreeLogger.SPAM, entry.getKey() + " -> " + entry.getValue());
                }
            }
        }

        public List<Method> getDeclarations(String mangledName) {
            List<Method> toReturn = this.mangledNamesToDeclarations.get(mangledName);
            return toReturn == null ? null : Collections.unmodifiableList(toReturn);
        }

        public List<Method> getImplementations(String mangledName) {
            List<Method> toReturn = this.mangledNamesToImplementations.get(mangledName);
            return toReturn == null ? toReturn : Collections.unmodifiableList(toReturn);
        }

        public SortedSet<String> getMangledNames() {
            return this.unmodifiableNames;
        }

        public Set<String> getSingleJsoIntfTypes() {
            return this.unmodifiableIntfNames;
        }

        private <K, V> void addToMap(Map<K, List<V>> map, K key, V value) {
            List<V> list = map.get(key);
            if (list == null) {
                map.put(key, Lists.create(value));
            } else {
                List maybeOther = Lists.add(list, value);
                if (maybeOther != list) {
                    map.put(key, maybeOther);
                }
            }
        }

        private JMethod findOverloadUsingErasure(JClassType implementingType, JMethod intfMethod) {
            int numParams = intfMethod.getParameters().length;
            JType[] erasedTypes = new JType[numParams];
            for (int i = 0; i < numParams; ++i) {
                erasedTypes[i] = intfMethod.getParameters()[i].getType().getErasedType();
            }
            block1: for (JMethod method : implementingType.getOverloads(intfMethod.getName())) {
                JParameter[] params = method.getParameters();
                if (params.length != numParams) continue;
                for (int i = 0; i < numParams; ++i) {
                    if (params[i].getType().getErasedType() != erasedTypes[i]) continue block1;
                }
                return method;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyInstanceMethodOracle
    implements HostedModeClassRewriter.InstanceMethodOracle {
        private final Map<String, Set<JClassType>> signatureToDeclaringClasses = new HashMap<String, Set<JClassType>>();

        public MyInstanceMethodOracle(Set<JClassType> jsoTypes, JClassType javaLangObject) {
            for (JClassType type : jsoTypes) {
                for (JMethod method : type.getMethods()) {
                    if (method.isStatic()) continue;
                    assert (!method.isAbstract()) : "Abstract method in JSO type " + method;
                    this.add(type, method);
                }
            }
            for (String intfName : OverlayTypesRewriter.this.jsoData.getSingleJsoIntfTypes()) {
                JClassType intf = OverlayTypesRewriter.this.typeOracle.findType(Name.InternalName.toSourceName((String)intfName));
                JClassType jso = OverlayTypesRewriter.this.typeOracle.getSingleJsoImpl(intf);
                for (JMethod method : intf.getMethods()) {
                    JClassType implementingJso = OverlayTypesRewriter.findImplementingTypeForMethod(jso, method);
                    assert (implementingJso != null) : "Jso should contain method: " + method.getJsniSignature();
                    this.add(implementingJso, method);
                }
            }
            for (JMethod method : javaLangObject.getMethods()) {
                if (method.isStatic()) continue;
                String signature = this.createSignature(method);
                HashSet<JClassType> declaringClasses = new HashSet<JClassType>();
                this.signatureToDeclaringClasses.put(signature, declaringClasses);
                declaringClasses.add(javaLangObject);
            }
        }

        public String findOriginalDeclaringClass(String desc, String signature) {
            Set<JClassType> declaringClasses = this.signatureToDeclaringClasses.get(signature);
            assert (declaringClasses != null) : "No classes for " + signature;
            if (declaringClasses.size() == 1) {
                return this.createDescriptor(declaringClasses.iterator().next());
            }
            String sourceName = desc.replace('/', '.');
            sourceName = sourceName.replace('$', '.');
            JClassType declaredType = OverlayTypesRewriter.this.typeOracle.findType(sourceName);
            if (declaringClasses.contains(declaredType)) {
                return desc;
            }
            for (JClassType possibleSupertype : declaringClasses) {
                if (!declaredType.isAssignableTo(possibleSupertype)) continue;
                return this.createDescriptor(possibleSupertype);
            }
            throw new IllegalArgumentException("Could not resolve signature '" + signature + "' from class '" + desc + "'");
        }

        private void add(JClassType type, JMethod method) {
            String signature = this.createSignature(method);
            Set<JClassType> declaringClasses = this.signatureToDeclaringClasses.get(signature);
            if (declaringClasses == null) {
                declaringClasses = new HashSet<JClassType>();
                this.signatureToDeclaringClasses.put(signature, declaringClasses);
            }
            declaringClasses.add(type);
        }

        private String createDescriptor(JClassType type) {
            String jniSignature = type.getJNISignature();
            return jniSignature.substring(1, jniSignature.length() - 1);
        }

        private String createSignature(JMethod method) {
            StringBuffer sb = new StringBuffer(method.getName());
            sb.append('(');
            for (JParameter param : method.getParameters()) {
                sb.append(param.getType().getJNISignature());
            }
            sb.append(')');
            sb.append(method.getReturnType().getJNISignature());
            String signature = sb.toString();
            return signature;
        }
    }
}

