/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder;

import com.google.gwt.dom.client.Element;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.googlecode.gwt.test.exceptions.GwtTestUiBinderException;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.internal.resources.ResourcePrototypeProxyBuilder;
import com.googlecode.gwt.test.uibinder.UiBinderInstanciator;
import com.googlecode.gwt.test.uibinder.UiTag;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiResourceManager {
    private final Object owner;
    private final Map<String, Object> resources = new HashMap<String, Object>();

    static final UiResourceManager newInstance(Object owner) {
        return new UiResourceManager(owner);
    }

    private UiResourceManager(Object owner) {
        this.owner = owner;
    }

    <T> T getUiResource(String alias) {
        return (T)this.resources.get(alias);
    }

    UiTag<?> registerImport(Map<String, Object> attributes, UiTag<?> parentTag, Object owner) {
        return new UiImportTag(attributes, parentTag, this.resources, owner);
    }

    UiTag<String> registerMsg(Map<String, Object> attributes, UiTag<?> parentTag, Object owner) {
        return new UiMsgTag(parentTag);
    }

    UiTag<?> registerResource(String localName, Map<String, Object> attributes, UiTag<?> parentTag, Object owner) throws GwtTestUiBinderException {
        String alias = this.getResourceAlias(localName, attributes);
        if (this.resources.containsKey(alias)) {
            throw new GwtTestUiBinderException("Two inner resources '" + alias + " are declared in " + owner.getClass().getSimpleName() + ".ui.xml. You should add a 'field' attribute to one of them");
        }
        Class<?> type = this.getResourceType(alias, localName, attributes);
        if ("with".equals(localName)) {
            Object resource = UiBinderInstanciator.getInstance(type, attributes, owner);
            this.resources.put(alias, resource);
            return new UiWithTag(resource);
        }
        ResourcePrototypeProxyBuilder builder = ResourcePrototypeProxyBuilder.createBuilder(type, owner.getClass());
        builder.name(alias);
        if ("style".equals(localName)) {
            return new UiStyleTag(builder, alias, parentTag, owner, this.resources);
        }
        if ("image".equals(localName)) {
            return new UiImgTag(builder, alias, parentTag, owner, this.resources, attributes);
        }
        if ("data".equals(localName)) {
            return new UiDataTag(builder, alias, parentTag, owner, this.resources, attributes);
        }
        throw new GwtTestUiBinderException("resource <" + localName + "> element is not yet implemented by gwt-test-utils");
    }

    UiTag<String> registerText(Map<String, Object> attributes, UiTag<?> parentTag, Object owner) {
        return new UiTextTag(attributes, parentTag, owner);
    }

    private String getResourceAlias(String localName, Map<String, Object> attributes) {
        String alias = (String)attributes.get("ui:field");
        if (alias == null && !"with".equals(localName)) {
            alias = localName;
        }
        if (alias == null) {
            throw new GwtTestUiBinderException("Cannot find the required 'field' value for tag <" + localName + "> in " + this.owner.getClass().getSimpleName() + ".ui.xml");
        }
        return alias;
    }

    private Class<?> getResourceType(String alias, String localName, Map<String, Object> attributes) {
        String type = (String)attributes.get("type");
        if (type == null && "image".equals(localName)) {
            return ImageResource.class;
        }
        if (type == null && "style".equals(localName)) {
            return CssResource.class;
        }
        if (type == null && "data".equals(localName)) {
            return DataResource.class;
        }
        if (type == null && "text".equals(localName)) {
            return TextResource.class;
        }
        if (type == null) {
            throw new GwtTestUiBinderException("<" + localName + "> element declared in " + this.owner.getClass().getSimpleName() + ".ui.xml must specify a 'type' attribute");
        }
        try {
            return GwtReflectionUtils.getClass(type);
        }
        catch (ClassNotFoundException e2) {
            throw new GwtTestUiBinderException("Cannot find class '" + type + "' for resource '" + alias + "' declared in file '" + this.owner.getClass().getSimpleName() + ".ui.xml'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiWithTag
    implements UiTag<Object> {
        private final Object with;

        public UiWithTag(Object with) {
            this.with = with;
        }

        @Override
        public void addElement(Element element) {
        }

        @Override
        public void addUiObject(UIObject uiObject) {
        }

        @Override
        public void addWidget(IsWidget isWidget) {
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public Object endTag() {
            return this.with;
        }

        @Override
        public UiTag<?> getParentTag() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiTextTag
    implements UiTag<String> {
        private final UiTag<?> parentTag;
        private final String text;

        UiTextTag(Map<String, Object> attributes, UiTag<?> parentTag, Object owner) {
            this.parentTag = parentTag;
            Object value = attributes.get("from");
            if (value instanceof TextResource) {
                this.text = ((TextResource)value).getText();
            } else if (value instanceof String) {
                this.text = (String)value;
            } else {
                throw new GwtTestUiBinderException("Error in " + owner.getClass().getSimpleName() + ".ui.xml : <ui:text> tag declared without 'from' attribute");
            }
        }

        @Override
        public void addElement(Element element) {
        }

        @Override
        public void addUiObject(UIObject uiObject) {
        }

        @Override
        public void addWidget(IsWidget widget) {
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public String endTag() {
            return this.text;
        }

        @Override
        public UiTag<?> getParentTag() {
            return this.parentTag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiStyleTag
    extends UiResourceTag {
        private final StringBuilder text = new StringBuilder();

        UiStyleTag(ResourcePrototypeProxyBuilder builder, String alias, UiTag<?> parentTag, Object owner, Map<String, Object> resources) {
            super(builder, alias, parentTag, owner, resources);
        }

        @Override
        public void appendText(String text) {
            this.text.append(text.trim());
        }

        @Override
        protected Object buildObject(ResourcePrototypeProxyBuilder builder) {
            return builder.text(this.text.toString()).build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class UiResourceTag
    implements UiTag<Object> {
        private final String alias;
        private final ResourcePrototypeProxyBuilder builder;
        private final Object owner;
        private final UiTag<?> parentTag;
        private final Map<String, Object> resources;
        private Object wrappedObject;

        UiResourceTag(ResourcePrototypeProxyBuilder builder, String alias, UiTag<?> parentTag, Object owner, Map<String, Object> resources) {
            this.builder = builder;
            this.owner = owner;
            this.parentTag = parentTag;
            this.alias = alias;
            this.resources = resources;
        }

        @Override
        public void addElement(Element element) {
        }

        @Override
        public void addUiObject(UIObject uiObject) {
        }

        @Override
        public void addWidget(IsWidget widget) {
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public Object endTag() {
            if (this.wrappedObject == null) {
                this.wrappedObject = this.buildObject(this.builder);
                Field resourceUiField = this.getUniqueUiField(this.alias);
                if (resourceUiField != null) {
                    try {
                        resourceUiField.set(this.owner, this.wrappedObject);
                    }
                    catch (Exception e) {
                        throw new ReflectionException(e);
                    }
                }
                this.resources.put(this.alias, this.wrappedObject);
            }
            return this.wrappedObject;
        }

        @Override
        public UiTag<?> getParentTag() {
            return this.parentTag;
        }

        protected abstract Object buildObject(ResourcePrototypeProxyBuilder var1);

        private Field getUniqueUiField(String alias) {
            Set<Field> resourceFields = GwtReflectionUtils.getFields(this.owner.getClass());
            if (resourceFields.size() == 0) {
                return null;
            }
            Field result = null;
            for (Field f : resourceFields) {
                if (!alias.equals(f.getName()) || !f.isAnnotationPresent(UiField.class)) continue;
                if (result != null) {
                    throw new GwtTestUiBinderException("There are more than one '" + f.getName() + "' @UiField in class '" + this.owner.getClass().getName() + "' or its superclass");
                }
                result = f;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiMsgTag
    implements UiTag<String> {
        private final UiTag<?> parentTag;
        private final StringBuilder sb;

        UiMsgTag(UiTag<?> parent) {
            this.parentTag = parent;
            this.sb = new StringBuilder();
        }

        @Override
        public void addElement(Element element) {
            this.sb.append("<").append(element.getTagName());
            this.sb.append(">").append(element.getInnerText()).append("</").append(element.getTagName()).append(">");
        }

        @Override
        public void addUiObject(UIObject uiObject) {
            this.parentTag.addUiObject(uiObject);
        }

        @Override
        public void addWidget(IsWidget isWidget) {
            this.parentTag.addWidget(isWidget);
        }

        @Override
        public void appendText(String data) {
            this.sb.append(data);
        }

        @Override
        public String endTag() {
            return this.sb.toString();
        }

        @Override
        public UiTag<?> getParentTag() {
            return this.parentTag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiImportTag
    implements UiTag<Object> {
        private final UiTag<?> parentTag;

        UiImportTag(Map<String, Object> attributes, UiTag<?> parentTag, Map<String, Object> resources, Object owner) {
            this.parentTag = parentTag;
            this.collectObjectToImport(attributes, resources, owner);
        }

        @Override
        public void addElement(Element element) {
        }

        @Override
        public void addUiObject(UIObject uiObject) {
        }

        @Override
        public void addWidget(IsWidget widget) {
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public Object endTag() {
            return null;
        }

        @Override
        public UiTag<?> getParentTag() {
            return this.parentTag;
        }

        private void collectMultipleImports(String importValue, Map<String, Object> resources, Object owner) {
            try {
                String className = importValue.substring(0, importValue.lastIndexOf(46));
                Class<?> clazz = GwtReflectionUtils.getClass(className);
                for (Field field : GwtReflectionUtils.getFields(clazz)) {
                    if (!Modifier.isStatic(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isProtected(field.getModifiers())) continue;
                    Object value = GwtReflectionUtils.getStaticFieldValue(clazz, field.getName());
                    resources.put(field.getName(), value);
                }
            }
            catch (Exception e) {
                throw new GwtTestUiBinderException("Error while trying to import multiple ui fields '" + importValue + "'", e);
            }
        }

        private Map<String, Object> collectObjectToImport(Map<String, Object> attributes, Map<String, Object> resources, Object owner) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String attrName = entry.getKey();
                String attrValue = entry.getValue().toString().trim();
                if (!"ui:field".equals(attrName) || attrValue.length() == 0) continue;
                int token = attrValue.lastIndexOf(46);
                if (token > -1 && token < attrValue.length() - 1 && attrValue.substring(token).equals(".*")) {
                    this.collectMultipleImports(attrValue, resources, owner);
                    continue;
                }
                this.collectSingleImport(attrValue, resources, owner);
            }
            return result;
        }

        private void collectSingleImport(String importValue, Map<String, Object> resources, Object owner) {
            try {
                int token = importValue.lastIndexOf(46);
                String className = importValue.substring(0, token);
                Class<?> clazz = GwtReflectionUtils.getClass(className);
                String fieldName = importValue.substring(token + 1);
                Object objectToImport = GwtReflectionUtils.getStaticFieldValue(clazz, fieldName);
                resources.put(fieldName, objectToImport);
            }
            catch (Exception e) {
                throw new GwtTestUiBinderException("Error while trying to import ui field '" + importValue + "'", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiImgTag
    extends UiResourceTag {
        UiImgTag(ResourcePrototypeProxyBuilder builder, String alias, UiTag<?> parentTag, Object owner, Map<String, Object> resources, Map<String, Object> attributes) {
            super(builder, alias, parentTag, owner, resources);
            String src = (String)attributes.get("src");
            builder.resourceURL(this.computeImageURLs(owner, src));
        }

        @Override
        protected Object buildObject(ResourcePrototypeProxyBuilder builder) {
            return builder.build();
        }

        private URL computeImageURLs(Object owner, String src) {
            URL imageURL = owner.getClass().getResource(src);
            if (imageURL == null) {
                throw new GwtTestUiBinderException("Cannot find image file with src=\"" + src + "\" declared in " + owner.getClass().getSimpleName() + ".ui.xml");
            }
            return imageURL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiDataTag
    extends UiResourceTag {
        UiDataTag(ResourcePrototypeProxyBuilder builder, String alias, UiTag<?> parentTag, Object owner, Map<String, Object> resources, Map<String, Object> attributes) {
            super(builder, alias, parentTag, owner, resources);
            String src = (String)attributes.get("src");
            builder.resourceURL(this.computeImageURL(owner, src));
        }

        @Override
        protected Object buildObject(ResourcePrototypeProxyBuilder builder) {
            return builder.build();
        }

        private URL computeImageURL(Object owner, String src) {
            URL dataURL = owner.getClass().getResource(src);
            if (dataURL == null) {
                throw new GwtTestUiBinderException("Cannot find binary file with src=\"" + src + "\" declared in " + owner.getClass().getSimpleName() + ".ui.xml");
            }
            return dataURL;
        }
    }
}

