/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.gxt2.internal.patchers;

import com.extjs.gxt.ui.client.core.El;
import com.google.gwt.user.client.Element;
import com.googlecode.gwt.test.internal.utils.GwtStyleUtils;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PatchClass(value=El.class)
class ElPatcher {
    private static Pattern UNIT_PATTERN = Pattern.compile("^(\\d+)[(px|em|%|en|ex|pt|in|cm|mm|pc)]{0,1}$");

    ElPatcher() {
    }

    @PatchMethod
    static String addUnits(String v, String defaultUnit) {
        if (v == null) {
            return "";
        }
        if ("undefined".equals(v = v.replaceAll(" ", ""))) {
            return "";
        }
        Matcher m = UNIT_PATTERN.matcher(v);
        if (m.matches()) {
            String unit = m.groupCount() == 3 ? m.group(2) : (defaultUnit != null && !"".equals(defaultUnit) ? defaultUnit : "px");
            return m.group(1) + unit;
        }
        return v;
    }

    @PatchMethod
    static El applyStyles(El el, String styles) {
        com.google.gwt.dom.client.Element elem = ElPatcher.getWrappedElement(el);
        LinkedHashMap styleProperties = GwtStyleUtils.getStyleProperties((String)elem.getAttribute("style"));
        for (Map.Entry entry : styleProperties.entrySet()) {
            elem.getStyle().setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return el;
    }

    @PatchMethod
    static void disableTextSelectInternal(Element e, boolean disable) {
    }

    @PatchMethod
    static boolean isLeftorRight(El el, String s) {
        return s != null && (s.contains("Left") || s.contains("Right"));
    }

    @PatchMethod
    static El removeStyleName(El el, String styleName) {
        if (styleName != null) {
            com.google.gwt.dom.client.Element elem = ElPatcher.getWrappedElement(el);
            elem.removeClassName(styleName);
        }
        return el;
    }

    @PatchMethod
    static El repaint(El el) {
        return el;
    }

    @PatchMethod
    static El setFocus(El el, boolean focus) {
        com.google.gwt.dom.client.Element dom = ElPatcher.getWrappedElement(el);
        if (focus) {
            dom.focus();
        } else {
            dom.blur();
        }
        return el;
    }

    private static com.google.gwt.dom.client.Element getWrappedElement(El el) {
        return (com.google.gwt.dom.client.Element)GwtReflectionUtils.getPrivateFieldValue((Object)el, (String)"dom");
    }
}

