/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import java.util.LinkedHashSet;
import java.util.Set;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.AttributeSpecifier;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.NodeTraversalChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeSpecifierChecker
extends NodeTraversalChecker {
    private final AttributeSpecifier specifier;

    public AttributeSpecifierChecker(AttributeSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        for (Node node : nodes) {
            Element e;
            String value;
            if (1 != node.getNodeType() || (value = (e = (Element)node.cast()).getAttribute(this.specifier.getName())) == null || "".equals(value)) continue;
            value = value.trim();
            if (this.specifier.getValue() == null) {
                result.add(node);
                continue;
            }
            String val = this.specifier.getValue();
            switch (this.specifier.getMatch()) {
                case EXACT: {
                    if (!value.equals(val)) break;
                    result.add(node);
                    break;
                }
                case HYPHEN: {
                    if (!value.equals(val) && !value.startsWith(val + '-')) break;
                    result.add(node);
                    break;
                }
                case PREFIX: {
                    if (!value.startsWith(val)) break;
                    result.add(node);
                    break;
                }
                case SUFFIX: {
                    if (!value.endsWith(val)) break;
                    result.add(node);
                    break;
                }
                case CONTAINS: {
                    if (!value.contains(val)) break;
                    result.add(node);
                    break;
                }
                case LIST: {
                    for (String v : value.split("\\s+")) {
                        if (!v.equals(val)) continue;
                        result.add(node);
                    }
                    break;
                }
            }
        }
        return result;
    }
}

