/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import com.google.gwt.dom.client.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.AttributeSpecifier;
import se.fishtank.css.selectors.AttributeSpecifierChecker;
import se.fishtank.css.selectors.NegationSpecifier;
import se.fishtank.css.selectors.NodeSelector;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.NodeTraversalChecker;
import se.fishtank.css.selectors.PseudoClassSpecifier;
import se.fishtank.css.selectors.PseudoClassSpecifierChecker;
import se.fishtank.css.selectors.PseudoNthSpecifier;
import se.fishtank.css.selectors.PseudoNthSpecifierChecker;
import se.fishtank.css.selectors.Scanner;
import se.fishtank.css.selectors.ScannerException;
import se.fishtank.css.selectors.Selector;
import se.fishtank.css.selectors.Specifier;
import se.fishtank.css.selectors.TagChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtNodeSelector
implements NodeSelector<Node> {
    private final Node root;

    public GwtNodeSelector(Node root) {
        Assert.notNull(root, "root is null!");
        short nodeType = root.getNodeType();
        Assert.isTrue(nodeType == 9 || nodeType == 1, "root must be a document or element node!");
        this.root = root;
    }

    @Override
    public Node querySelector(String selectors) throws NodeSelectorException {
        Set<Node> result = this.querySelectorAll(selectors);
        if (result.isEmpty()) {
            return null;
        }
        return result.iterator().next();
    }

    @Override
    public Set<Node> querySelectorAll(String selectors) throws NodeSelectorException {
        List<List<Selector>> groups;
        Assert.notNull(selectors, "selectors is null!");
        try {
            Scanner scanner = new Scanner(selectors);
            groups = scanner.scan();
        }
        catch (ScannerException e) {
            throw new NodeSelectorException(e);
        }
        LinkedHashSet<Node> results = new LinkedHashSet<Node>();
        for (List<Selector> parts : groups) {
            Set<Node> result = this.check(parts);
            if (result.isEmpty()) continue;
            results.addAll(result);
        }
        return results;
    }

    private Set<Node> check(List<Selector> parts) throws NodeSelectorException {
        Set<Node> result = new LinkedHashSet<Node>();
        result.add(this.root);
        for (Selector selector : parts) {
            NodeTraversalChecker checker = new TagChecker(selector);
            result = ((NodeTraversalChecker)checker).check(result, this.root);
            if (!selector.hasSpecifiers()) continue;
            for (Specifier specifier : selector.getSpecifiers()) {
                switch (specifier.getType()) {
                    case ATTRIBUTE: {
                        checker = new AttributeSpecifierChecker((AttributeSpecifier)specifier);
                        break;
                    }
                    case PSEUDO: {
                        if (specifier instanceof PseudoClassSpecifier) {
                            checker = new PseudoClassSpecifierChecker((PseudoClassSpecifier)specifier);
                            break;
                        }
                        if (!(specifier instanceof PseudoNthSpecifier)) break;
                        checker = new PseudoNthSpecifierChecker((PseudoNthSpecifier)specifier);
                        break;
                    }
                    case NEGATION: {
                        final Set<Node> negationNodes = this.checkNegationSpecifier((NegationSpecifier)specifier);
                        checker = new NodeTraversalChecker(){

                            @Override
                            public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
                                LinkedHashSet<Node> set = new LinkedHashSet<Node>(nodes);
                                set.removeAll(negationNodes);
                                return set;
                            }
                        };
                    }
                }
                if (!(result = ((NodeTraversalChecker)checker).check(result, this.root)).isEmpty()) continue;
                return result;
            }
        }
        return result;
    }

    private Set<Node> checkNegationSpecifier(NegationSpecifier specifier) throws NodeSelectorException {
        ArrayList<Selector> parts = new ArrayList<Selector>(1);
        parts.add(specifier.getSelector());
        return this.check(parts);
    }
}

