/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import java.util.LinkedHashSet;
import java.util.Set;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.GwtDomHelper;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.NodeTraversalChecker;
import se.fishtank.css.selectors.PseudoNthSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PseudoNthSpecifierChecker
extends NodeTraversalChecker {
    private Set<Node> nodes;
    private Set<Node> result;
    private final PseudoNthSpecifier specifier;

    public PseudoNthSpecifierChecker(PseudoNthSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        this.nodes = nodes;
        this.result = new LinkedHashSet<Node>();
        String value = this.specifier.getValue();
        if ("nth-child".equals(value)) {
            this.addNthChild();
        } else if ("nth-last-child".equals(value)) {
            this.addNthLastChild();
        } else if ("nth-of-type".equals(value)) {
            this.addNthOfType();
        } else if ("nth-last-of-type".equals(value)) {
            this.addNthLastOfType();
        } else {
            throw new NodeSelectorException("Unknown pseudo nth class: " + value);
        }
        return this.result;
    }

    private void addNthChild() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = GwtDomHelper.getPreviousSiblingElement(node);
            while (n != null) {
                ++count;
                n = GwtDomHelper.getPreviousSiblingElement((Node)n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthLastChild() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = GwtDomHelper.getNextSiblingElement(node);
            while (n != null) {
                ++count;
                n = GwtDomHelper.getNextSiblingElement((Node)n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthLastOfType() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = GwtDomHelper.getNextSiblingElement(node);
            while (n != null) {
                if (n.getNodeName().equals(node.getNodeName())) {
                    ++count;
                }
                n = GwtDomHelper.getNextSiblingElement((Node)n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthOfType() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = GwtDomHelper.getPreviousSiblingElement(node);
            while (n != null) {
                if (n.getNodeName().equals(node.getNodeName())) {
                    ++count;
                }
                n = GwtDomHelper.getPreviousSiblingElement((Node)n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }
}

