/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import java.util.List;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.Specifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Selector {
    public static final String UNIVERSAL_TAG = "*";
    private final Combinator combinator;
    private final List<Specifier> specifiers;
    private final String tagName;

    public Selector() {
        this.tagName = UNIVERSAL_TAG;
        this.combinator = Combinator.DESCENDANT;
        this.specifiers = null;
    }

    public Selector(String tagName, Combinator combinator) {
        Assert.notNull(tagName, "tagName is null!");
        Assert.notNull((Object)combinator, "combinator is null!");
        this.tagName = tagName;
        this.combinator = combinator;
        this.specifiers = null;
    }

    public Selector(String tagName, Combinator combinator, List<Specifier> specifiers) {
        Assert.notNull(tagName, "tagName is null!");
        Assert.notNull((Object)combinator, "combinator is null!");
        this.tagName = tagName;
        this.combinator = combinator;
        this.specifiers = specifiers;
    }

    public Selector(String tagName, List<Specifier> specifiers) {
        Assert.notNull(tagName, "tagName is null!");
        this.tagName = tagName;
        this.combinator = Combinator.DESCENDANT;
        this.specifiers = specifiers;
    }

    public Combinator getCombinator() {
        return this.combinator;
    }

    public List<Specifier> getSpecifiers() {
        return this.specifiers;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean hasSpecifiers() {
        return this.specifiers != null && !this.specifiers.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Combinator {
        ADJACENT_SIBLING,
        CHILD,
        DESCENDANT,
        GENERAL_SIBLING;

    }
}

