/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSFunction;
import com.googlecode.jslint4java.JSIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLintResult {
    private final long duration;
    private final List<JSFunction> functions = new ArrayList<JSFunction>();
    private final List<String> globals = new ArrayList<String>();
    private final List<JSIdentifier> implieds = new ArrayList<JSIdentifier>();
    private final List<Issue> issues = new ArrayList<Issue>();
    private final boolean json;
    private final Map<String, Integer> member = new HashMap<String, Integer>();
    private final String name;
    private final String report;
    private final List<JSIdentifier> unused = new ArrayList<JSIdentifier>();
    private final List<String> urls = new ArrayList<String>();

    private JSLintResult(ResultBuilder b) {
        this.name = b.name;
        this.duration = b.duration;
        this.issues.addAll(b.issues);
        this.functions.addAll(b.functions);
        this.globals.addAll(b.globals);
        this.implieds.addAll(b.implieds);
        this.json = b.json;
        this.member.putAll(b.member);
        this.report = b.report;
        this.unused.addAll(b.unused);
        this.urls.addAll(b.urls);
    }

    public long getDuration() {
        return this.duration;
    }

    public List<JSFunction> getFunctions() {
        return this.functions;
    }

    public List<String> getGlobals() {
        return this.globals;
    }

    public List<JSIdentifier> getImplieds() {
        return this.implieds;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Map<String, Integer> getMember() {
        return this.member;
    }

    public String getName() {
        return this.name;
    }

    public String getReport() {
        return this.report;
    }

    public List<JSIdentifier> getUnused() {
        return this.unused;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public boolean isJson() {
        return this.json;
    }

    public static class ResultBuilder {
        private long duration;
        private final List<JSFunction> functions = new ArrayList<JSFunction>();
        private final List<String> globals = new ArrayList<String>();
        private final List<JSIdentifier> implieds = new ArrayList<JSIdentifier>();
        private final List<Issue> issues = new ArrayList<Issue>();
        private boolean json;
        private final Map<String, Integer> member = new HashMap<String, Integer>();
        private final String name;
        private String report;
        private final List<JSIdentifier> unused = new ArrayList<JSIdentifier>();
        private final List<String> urls = new ArrayList<String>();

        public ResultBuilder(String name) {
            this.name = name;
        }

        public ResultBuilder addFunction(JSFunction f) {
            this.functions.add(f);
            return this;
        }

        public ResultBuilder addGlobal(String global) {
            this.globals.add(global);
            return this;
        }

        public ResultBuilder addImplied(JSIdentifier id) {
            this.implieds.add(id);
            return this;
        }

        public ResultBuilder addIssue(Issue issue) {
            this.issues.add(issue);
            return this;
        }

        public ResultBuilder addMember(String name, int count) {
            this.member.put(name, count);
            return this;
        }

        public ResultBuilder addUnused(JSIdentifier id) {
            this.unused.add(id);
            return this;
        }

        public ResultBuilder addUrl(String url) {
            this.urls.add(url);
            return this;
        }

        public JSLintResult build() {
            return new JSLintResult(this);
        }

        public ResultBuilder duration(long millis) {
            this.duration = millis;
            return this;
        }

        public ResultBuilder json(boolean json) {
            this.json = json;
            return this;
        }

        public ResultBuilder report(String report) {
            this.report = report;
            return this;
        }
    }
}

