/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.StringArray;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Option {
    ADSAFE("If adsafe rules should be enforced", Boolean.class),
    BITWISE("If bitwise operators should not be allowed", Boolean.class),
    BROWSER("If the standard browser globals should be predefined", Boolean.class),
    CAP("If upper case html should be allowed", Boolean.class),
    CONTINUE("If the continuation statement should be tolerated", Boolean.class),
    CSS("If css workarounds should be tolerated", Boolean.class),
    DEBUG("If debugger statements should be allowed", Boolean.class),
    DEVEL("If logging should be allowed (console, alert, etc.)", Boolean.class),
    ES5("If es5 syntax should be allowed", Boolean.class),
    EVIL("If eval should be allowed", Boolean.class),
    FORIN("If for in statements need not filter", Boolean.class),
    FRAGMENT("If html fragments should be allowed", Boolean.class),
    INDENT("The indentation factor", Integer.class),
    MAXERR("The maximum number of errors to allow", Integer.class),
    MAXLEN("The maximum length of a source line", Integer.class),
    NEWCAP("If constructor names must be capitalized", Boolean.class),
    NOMEN("If names should be checked", Boolean.class),
    ON("If html event handlers should be allowed", Boolean.class),
    ONEVAR("If only one var statement per function should be allowed", Boolean.class),
    PASSFAIL("If the scan should stop on first error", Boolean.class),
    PLUSPLUS("If increment/decrement should not be allowed", Boolean.class),
    PREDEF("The names of predefined global variables", StringArray.class),
    REGEXP("If the . should not be allowed in regexp literals", Boolean.class),
    RHINO("If the rhino environment globals should be predefined", Boolean.class),
    SAFE("If use of some browser features should be restricted", Boolean.class),
    STRICT("Require the \"use strict\"; pragma", Boolean.class),
    SUB("If all forms of subscript notation are tolerated", Boolean.class),
    UNDEF("If variables should be declared before used", Boolean.class),
    WHITE("If strict whitespace rules apply", Boolean.class),
    WIDGET("If the yahoo widgets globals should be predefined", Boolean.class),
    WINDOWS("If ms windows-specigic globals should be predefined", Boolean.class);

    private String description;
    private Class<?> type;

    private Option(String description, Class<?> type) {
        this.description = description;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLowerName() {
        return this.name().toLowerCase(Locale.getDefault());
    }

    public Class<?> getType() {
        return this.type;
    }

    public static int maximumNameLength() {
        int maxOptLen = 0;
        for (Option o : Option.values()) {
            int len = o.name().length();
            if (len <= maxOptLen) continue;
            maxOptLen = len;
        }
        return maxOptLen;
    }

    public Set<Option> theGoodParts() {
        return EnumSet.of(WHITE, new Option[]{ONEVAR, UNDEF, NEWCAP, NOMEN, REGEXP, PLUSPLUS, BITWISE});
    }

    public String toString() {
        return this.getLowerName() + "[" + this.getDescription() + "]";
    }
}

