/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSFunction;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.OptionParser;
import com.googlecode.jslint4java.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLint {
    private static final String DEFAULT_INDENT = "4";
    private static final String DEFAULT_MAXERR = "50";
    private final Map<Option, Object> options = new EnumMap<Option, Object>(Option.class);
    private final ScriptableObject scope;
    private final ContextFactory contextFactory;

    JSLint(ContextFactory contextFactory, ScriptableObject scope) {
        this.contextFactory = contextFactory;
        this.scope = scope;
        this.scope.sealObject();
    }

    public void addOption(Option o) {
        this.options.put(o, Boolean.TRUE);
    }

    public void addOption(Option o, String arg) {
        OptionParser optionParser = new OptionParser();
        this.options.put(o, optionParser.parse(o.getType(), arg));
    }

    private void applyDefaultOptions() {
        if (!this.options.containsKey((Object)Option.INDENT)) {
            this.addOption(Option.INDENT, DEFAULT_INDENT);
        }
        if (!this.options.containsKey((Object)Option.MAXERR)) {
            this.addOption(Option.MAXERR, DEFAULT_MAXERR);
        }
    }

    private JSLintResult buildResults(final String systemId, final long startNanos, final long endNanos) {
        return (JSLintResult)this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                JSLintResult.ResultBuilder b = new JSLintResult.ResultBuilder(systemId);
                b.duration(TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos));
                for (Issue issue : JSLint.this.readErrors(systemId)) {
                    b.addIssue(issue);
                }
                b.report(JSLint.this.callReport(false));
                Scriptable lintScope = (Scriptable)JSLint.this.scope.get("JSLINT", (Scriptable)JSLint.this.scope);
                Object o = lintScope.get("data", lintScope);
                if (o != UniqueTag.NOT_FOUND) {
                    Function reportFunc = (Function)o;
                    Scriptable data = (Scriptable)reportFunc.call(cx, (Scriptable)JSLint.this.scope, (Scriptable)JSLint.this.scope, new Object[0]);
                    for (String string : Util.listValueOfType("globals", String.class, data)) {
                        b.addGlobal(string);
                    }
                    for (String string : Util.listValueOfType("urls", String.class, data)) {
                        b.addUrl(string);
                    }
                    for (Map.Entry entry : JSLint.this.getDataMembers(data).entrySet()) {
                        b.addMember((String)entry.getKey(), (Integer)entry.getValue());
                    }
                    b.json(Util.booleanValue("json", data));
                    for (JSFunction jSFunction : Util.listValue("functions", data, new JSFunctionConverter())) {
                        b.addFunction(jSFunction);
                    }
                }
                return b.build();
            }
        });
    }

    private String callReport(final boolean errorsOnly) {
        return (String)this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Object[] args = new Object[]{errorsOnly};
                Scriptable lintScope = (Scriptable)JSLint.this.scope.get("JSLINT", (Scriptable)JSLint.this.scope);
                Object report = lintScope.get("report", lintScope);
                if (report == UniqueTag.NOT_FOUND) {
                    return "";
                }
                Function reportFunc = (Function)report;
                return reportFunc.call(cx, (Scriptable)JSLint.this.scope, (Scriptable)JSLint.this.scope, args);
            }
        });
    }

    private void doLint(final String javaScript) {
        this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                String src = javaScript == null ? "" : javaScript;
                Object[] args = new Object[]{src, JSLint.this.optionsAsJavaScriptObject()};
                Function lintFunc = (Function)JSLint.this.scope.get("JSLINT", (Scriptable)JSLint.this.scope);
                lintFunc.call(cx, (Scriptable)JSLint.this.scope, (Scriptable)JSLint.this.scope, args);
                return null;
            }
        });
    }

    private Map<String, Integer> getDataMembers(Scriptable data) {
        Object o1 = data.get("member", data);
        if (o1 == UniqueTag.NOT_FOUND) {
            return new HashMap<String, Integer>();
        }
        Scriptable member = (Scriptable)o1;
        Object[] propertyIds = ScriptableObject.getPropertyIds((Scriptable)member);
        HashMap<String, Integer> members = new HashMap<String, Integer>(propertyIds.length);
        for (Object id : propertyIds) {
            String k = id.toString();
            members.put(k, Util.intValue(k, member));
        }
        return members;
    }

    public String getEdition() {
        Scriptable lintScope = (Scriptable)this.scope.get("JSLINT", (Scriptable)this.scope);
        return (String)lintScope.get("edition", lintScope);
    }

    public JSLintResult lint(String systemId, Reader reader) throws IOException {
        return this.lint(systemId, Util.readerToString(reader));
    }

    public JSLintResult lint(String systemId, String javaScript) {
        long before = System.nanoTime();
        this.doLint(javaScript);
        long after = System.nanoTime();
        return this.buildResults(systemId, before, after);
    }

    private Scriptable optionsAsJavaScriptObject() {
        return (Scriptable)this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                JSLint.this.applyDefaultOptions();
                Scriptable opts = cx.newObject((Scriptable)JSLint.this.scope);
                for (Map.Entry entry : JSLint.this.options.entrySet()) {
                    String key = ((Option)((Object)entry.getKey())).getLowerName();
                    Object value = Util.javaToJS(entry.getValue(), opts);
                    opts.put(key, opts, value);
                }
                return opts;
            }
        });
    }

    private List<Issue> readErrors(String systemId) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Scriptable JSLINT = (Scriptable)this.scope.get("JSLINT", (Scriptable)this.scope);
        Scriptable errors = (Scriptable)JSLINT.get("errors", JSLINT);
        int count = Util.intValue("length", errors);
        for (int i = 0; i < count; ++i) {
            Scriptable err = (Scriptable)errors.get(i, errors);
            if (err == null) continue;
            issues.add(Issue.IssueBuilder.fromJavaScript(systemId, err));
        }
        return issues;
    }

    public String report(String javaScript) {
        return this.report(javaScript, false);
    }

    public String report(String javaScript, boolean errorsOnly) {
        this.doLint(javaScript);
        return this.callReport(errorsOnly);
    }

    public void resetOptions() {
        this.options.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JSFunctionConverter
    implements Util.Converter<JSFunction> {
        private JSFunctionConverter() {
        }

        @Override
        public JSFunction convert(Object obj) {
            Scriptable scope = (Scriptable)obj;
            String name = Util.stringValue("name", scope);
            int line = Util.intValue("line", scope);
            JSFunction.Builder b = new JSFunction.Builder(name, line);
            b.last(Util.intValue("last", scope));
            for (String param : Util.listValue("params", scope, new JSFunctionParamConverter())) {
                b.addParam(param);
            }
            for (String closure : Util.listValueOfType("closure", String.class, scope)) {
                b.addClosure(closure);
            }
            for (String var : Util.listValueOfType("var", String.class, scope)) {
                b.addVar(var);
            }
            for (String exception : Util.listValueOfType("exception", String.class, scope)) {
                b.addException(exception);
            }
            for (String outer : Util.listValueOfType("outer", String.class, scope)) {
                b.addOuter(outer);
            }
            for (String unused : Util.listValueOfType("unused", String.class, scope)) {
                b.addUnused(unused);
            }
            for (String undef : Util.listValueOfType("undef", String.class, scope)) {
                b.addUndef(undef);
            }
            for (String global : Util.listValueOfType("global", String.class, scope)) {
                b.addGlobal(global);
            }
            for (String label : Util.listValueOfType("label", String.class, scope)) {
                b.addLabel(label);
            }
            return b.build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JSFunctionParamConverter
    implements Util.Converter<String> {
        private JSFunctionParamConverter() {
        }

        @Override
        public String convert(Object obj) {
            Scriptable scope = (Scriptable)obj;
            return Util.stringValue("string", scope);
        }
    }
}

