/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.StringArray;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Option {
    ANON("If the space may be omitted in anonymous function declarations", Boolean.class),
    BITWISE("If bitwise operators should be allowed", Boolean.class),
    BROWSER("If the standard browser globals should be predefined", Boolean.class),
    CAP("If upper case html should be allowed", Boolean.class),
    CONTINUE("If the continuation statement should be tolerated", Boolean.class),
    CSS("If css workarounds should be tolerated", Boolean.class),
    DEBUG("If debugger statements should be allowed", Boolean.class),
    DEVEL("If logging should be allowed (console, alert, etc.)", Boolean.class),
    EQEQ("If == should be allowed", Boolean.class),
    ES5("If es5 syntax should be allowed", Boolean.class),
    EVIL("If eval should be allowed", Boolean.class),
    FORIN("If for in statements need not filter", Boolean.class),
    FRAGMENT("If html fragments should be allowed", Boolean.class),
    INDENT("The indentation factor", Integer.class),
    MAXERR("The maximum number of errors to allow", Integer.class),
    MAXLEN("The maximum length of a source line", Integer.class),
    NEWCAP("If constructor names capitalization is ignored", Boolean.class),
    NODE("If node.js globals should be predefined", Boolean.class),
    NOMEN("If names may have dangling _", Boolean.class),
    ON("If html event handlers should be allowed", Boolean.class),
    PASSFAIL("If the scan should stop on first error", Boolean.class),
    PLUSPLUS("If increment/decrement should be allowed", Boolean.class),
    PREDEF("The names of predefined global variables", StringArray.class),
    PROPERTIES("If all property names must be declared with /*properties*/", Boolean.class),
    REGEXP("If the . should be allowed in regexp literals", Boolean.class),
    RHINO("If the rhino environment globals should be predefined", Boolean.class),
    SLOPPY("If the 'use strict'; pragma is optional", Boolean.class),
    SUB("If all forms of subscript notation are tolerated", Boolean.class),
    UNDEF("If variables can be declared out of order", Boolean.class),
    UNPARAM("If unused parameters should be tolerated", Boolean.class),
    VARS("If multiple var statements per function should be allowed", Boolean.class),
    WHITE("If sloppy whitespace is tolerated", Boolean.class),
    WIDGET("If the yahoo widgets globals should be predefined", Boolean.class),
    WINDOWS("If ms windows-specific globals should be predefined", Boolean.class);

    private String description;
    private Class<?> type;

    private Option(String description, Class<?> type) {
        this.description = description;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLowerName() {
        return this.name().toLowerCase(Locale.getDefault());
    }

    public Class<?> getType() {
        return this.type;
    }

    public static int maximumNameLength() {
        int maxOptLen = 0;
        for (Option o : Option.values()) {
            int len = o.name().length();
            if (len <= maxOptLen) continue;
            maxOptLen = len;
        }
        return maxOptLen;
    }

    public String toString() {
        return this.getLowerName() + "[" + this.getDescription() + "]";
    }
}

