/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeBomInputStream
extends InputStream {
    private final PushbackInputStream in;
    private final BOM bom;
    private boolean skipped = false;

    public UnicodeBomInputStream(InputStream inputStream) throws NullPointerException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("invalid input stream: null is not allowed");
        }
        this.in = new PushbackInputStream(inputStream, 4);
        byte[] bom = new byte[4];
        int read = this.in.read(bom);
        switch (read) {
            case 4: {
                if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                    this.bom = BOM.UTF_32_LE;
                    break;
                }
                if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    this.bom = BOM.UTF_32_BE;
                    break;
                }
            }
            case 3: {
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    this.bom = BOM.UTF_8;
                    break;
                }
            }
            case 2: {
                if (bom[0] == -1 && bom[1] == -2) {
                    this.bom = BOM.UTF_16_LE;
                    break;
                }
                if (bom[0] == -2 && bom[1] == -1) {
                    this.bom = BOM.UTF_16_BE;
                    break;
                }
            }
            default: {
                this.bom = BOM.NONE;
            }
        }
        if (read > 0) {
            this.in.unread(bom, 0, read);
        }
    }

    public final BOM getBOM() {
        return this.bom;
    }

    public final synchronized UnicodeBomInputStream skipBOM() throws IOException {
        if (!this.skipped) {
            this.skip(this.bom.bytes.length);
            this.skipped = true;
        }
        return this;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b) throws IOException, NullPointerException {
        return this.in.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException {
        return this.in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BOM {
        NONE(new byte[0], "NONE"),
        UTF_8(new byte[]{-17, -69, -65}, "UTF-8"),
        UTF_16_LE(new byte[]{-1, -2}, "UTF-16 little-endian"),
        UTF_16_BE(new byte[]{-2, -1}, "UTF-16 big-endian"),
        UTF_32_LE(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian"),
        UTF_32_BE(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian");

        private final byte[] bytes;
        private final String description;

        private BOM(byte[] bytes, String description) {
            this.bytes = bytes;
            this.description = description;
        }

        public byte[] getBytes() {
            byte[] result = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, result, 0, this.bytes.length);
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }
}

