/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.formatter;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;

public class PlainFormatter
implements JSLintResultFormatter {
    public String footer() {
        return null;
    }

    public String format(JSLintResult result) {
        StringBuilder sb = new StringBuilder();
        for (Issue issue : result.getIssues()) {
            sb.append(this.outputOneIssue(issue));
        }
        return sb.toString();
    }

    public String header() {
        return null;
    }

    private String outputOneIssue(Issue issue) {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(issue.getSystemId());
        sb.append(':');
        sb.append(issue.getLine());
        sb.append(':');
        sb.append(issue.getCharacter());
        sb.append(": ");
        sb.append(issue.getReason());
        sb.append(nl);
        String evidence = issue.getEvidence();
        if (evidence != null && !"".equals(evidence)) {
            sb.append(evidence);
            sb.append(nl);
            sb.append(this.spaces(issue.getCharacter() - 1));
            sb.append("^");
            sb.append(nl);
        }
        return sb.toString();
    }

    protected String spaces(int howmany) {
        StringBuffer sb = new StringBuffer(howmany);
        for (int i = 0; i < howmany; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

