/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhoneNumberMatcher
implements Iterator<PhoneNumberMatch> {
    private static final Pattern PATTERN;
    private static final Pattern PUB_PAGES;
    private static final Pattern SLASH_SEPARATED_DATES;
    private static final Pattern MATCHING_BRACKETS;
    private static final Pattern GROUP_SEPARATOR;
    private static final Pattern LEAD_CLASS;
    private final PhoneNumberUtil phoneUtil;
    private final CharSequence text;
    private final String preferredRegion;
    private final PhoneNumberUtil.Leniency leniency;
    private long maxTries;
    private State state = State.NOT_READY;
    private PhoneNumberMatch lastMatch = null;
    private int searchIndex = 0;

    private static String limit(int lower, int upper) {
        if (lower < 0 || upper <= 0 || upper < lower) {
            throw new IllegalArgumentException();
        }
        return "{" + lower + "," + upper + "}";
    }

    PhoneNumberMatcher(PhoneNumberUtil util, CharSequence text, String country, PhoneNumberUtil.Leniency leniency, long maxTries) {
        if (util == null || leniency == null) {
            throw new NullPointerException();
        }
        if (maxTries < 0L) {
            throw new IllegalArgumentException();
        }
        this.phoneUtil = util;
        this.text = text != null ? text : "";
        this.preferredRegion = country;
        this.leniency = leniency;
        this.maxTries = maxTries;
    }

    @Override
    public boolean hasNext() {
        if (this.state == State.NOT_READY) {
            this.lastMatch = this.find(this.searchIndex);
            if (this.lastMatch == null) {
                this.state = State.DONE;
            } else {
                this.searchIndex = this.lastMatch.end();
                this.state = State.READY;
            }
        }
        return this.state == State.READY;
    }

    @Override
    public PhoneNumberMatch next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PhoneNumberMatch result = this.lastMatch;
        this.lastMatch = null;
        this.state = State.NOT_READY;
        return result;
    }

    private PhoneNumberMatch find(int index) {
        Matcher matcher = PATTERN.matcher(this.text);
        while (this.maxTries > 0L && matcher.find(index)) {
            int start = matcher.start();
            CharSequence candidate = this.text.subSequence(start, matcher.end());
            PhoneNumberMatch match = this.extractMatch(candidate = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.SECOND_NUMBER_START_PATTERN, candidate), start);
            if (match != null) {
                return match;
            }
            index = start + candidate.length();
            --this.maxTries;
        }
        return null;
    }

    private static CharSequence trimAfterFirstMatch(Pattern pattern, CharSequence candidate) {
        Matcher trailingCharsMatcher = pattern.matcher(candidate);
        if (trailingCharsMatcher.find()) {
            candidate = candidate.subSequence(0, trailingCharsMatcher.start());
        }
        return candidate;
    }

    static boolean isLatinLetter(char letter) {
        if (!Character.isLetter(letter) && Character.getType(letter) != 6) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(letter);
        return block.equals(Character.UnicodeBlock.BASIC_LATIN) || block.equals(Character.UnicodeBlock.LATIN_1_SUPPLEMENT) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_A) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_B) || block.equals(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS);
    }

    private static boolean isCurrencySymbol(char character) {
        return Character.getType(character) == 26;
    }

    private PhoneNumberMatch extractMatch(CharSequence candidate, int offset) {
        if (PUB_PAGES.matcher(candidate).find() || SLASH_SEPARATED_DATES.matcher(candidate).find()) {
            return null;
        }
        String rawString = ((Object)candidate).toString();
        PhoneNumberMatch match = this.parseAndVerify(rawString, offset);
        if (match != null) {
            return match;
        }
        return this.extractInnerMatch(rawString, offset);
    }

    private PhoneNumberMatch extractInnerMatch(String candidate, int offset) {
        Matcher groupMatcher = GROUP_SEPARATOR.matcher(candidate);
        if (groupMatcher.find()) {
            CharSequence firstGroupOnly = candidate.substring(0, groupMatcher.start());
            PhoneNumberMatch match = this.parseAndVerify((firstGroupOnly = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, firstGroupOnly)).toString(), offset);
            if (match != null) {
                return match;
            }
            --this.maxTries;
            int withoutFirstGroupStart = groupMatcher.end();
            CharSequence withoutFirstGroup = candidate.substring(withoutFirstGroupStart);
            match = this.parseAndVerify((withoutFirstGroup = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, withoutFirstGroup)).toString(), offset + withoutFirstGroupStart);
            if (match != null) {
                return match;
            }
            --this.maxTries;
            if (this.maxTries > 0L) {
                int lastGroupStart = withoutFirstGroupStart;
                while (groupMatcher.find()) {
                    lastGroupStart = groupMatcher.start();
                }
                CharSequence withoutLastGroup = candidate.substring(0, lastGroupStart);
                if ((withoutLastGroup = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, withoutLastGroup)).equals(firstGroupOnly)) {
                    return null;
                }
                match = this.parseAndVerify(withoutLastGroup.toString(), offset);
                if (match != null) {
                    return match;
                }
                --this.maxTries;
            }
        }
        return null;
    }

    private PhoneNumberMatch parseAndVerify(String candidate, int offset) {
        try {
            Phonenumber.PhoneNumber number;
            if (!MATCHING_BRACKETS.matcher(candidate).matches()) {
                return null;
            }
            if (this.leniency.compareTo(PhoneNumberUtil.Leniency.VALID) >= 0) {
                char nextChar;
                char previousChar;
                if (offset > 0 && !LEAD_CLASS.matcher(candidate).lookingAt() && (PhoneNumberMatcher.isCurrencySymbol(previousChar = this.text.charAt(offset - 1)) || PhoneNumberMatcher.isLatinLetter(previousChar))) {
                    return null;
                }
                int lastCharIndex = offset + candidate.length();
                if (lastCharIndex < this.text.length() && (PhoneNumberMatcher.isCurrencySymbol(nextChar = this.text.charAt(lastCharIndex)) || PhoneNumberMatcher.isLatinLetter(nextChar))) {
                    return null;
                }
            }
            if (this.leniency.verify(number = this.phoneUtil.parse(candidate, this.preferredRegion), candidate, this.phoneUtil)) {
                return new PhoneNumberMatch(offset, candidate, number);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        PUB_PAGES = Pattern.compile("\\d{1,5}-+\\d{1,5}\\s{0,4}\\(\\d{1,4}");
        SLASH_SEPARATED_DATES = Pattern.compile("(?:(?:[0-3]?\\d/[01]?\\d)|(?:[01]?\\d/[0-3]?\\d))/(?:[12]\\d)?\\d{2}");
        String openingParens = "(\\[\uff08\uff3b";
        String closingParens = ")\\]\uff09\uff3d";
        String nonParens = "[^" + openingParens + closingParens + "]";
        String bracketPairLimit = PhoneNumberMatcher.limit(0, 3);
        MATCHING_BRACKETS = Pattern.compile("(?:[" + openingParens + "])?" + "(?:" + nonParens + "+" + "[" + closingParens + "])?" + nonParens + "+" + "(?:[" + openingParens + "]" + nonParens + "+[" + closingParens + "])" + bracketPairLimit + nonParens + "*");
        String leadLimit = PhoneNumberMatcher.limit(0, 2);
        String punctuationLimit = PhoneNumberMatcher.limit(0, 4);
        int digitBlockLimit = 18;
        String blockLimit = PhoneNumberMatcher.limit(0, digitBlockLimit);
        String punctuation = "[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]" + punctuationLimit;
        String digitSequence = "\\p{Nd}" + PhoneNumberMatcher.limit(1, digitBlockLimit);
        String leadClassChars = openingParens + "+\uff0b";
        String leadClass = "[" + leadClassChars + "]";
        LEAD_CLASS = Pattern.compile(leadClass);
        GROUP_SEPARATOR = Pattern.compile("\\p{Z}[^" + leadClassChars + "\\p{Nd}]*");
        PATTERN = Pattern.compile("(?:" + leadClass + punctuation + ")" + leadLimit + digitSequence + "(?:" + punctuation + digitSequence + ")" + blockLimit + "(?:" + PhoneNumberUtil.EXTN_PATTERNS_FOR_MATCHING + ")?", 66);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_READY,
        READY,
        DONE;

    }
}

