/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AlternateFormatsCountryCodeSet;
import com.google.i18n.phonenumbers.PhoneNumberMatcher;
import com.google.i18n.phonenumbers.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetadataManager {
    private static final String ALTERNATE_FORMATS_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto";
    private static final Logger LOGGER = Logger.getLogger(MetadataManager.class.getName());
    private static final Map<Integer, Phonemetadata.PhoneMetadata> callingCodeToAlternateFormatsMap = Collections.synchronizedMap(new HashMap());
    private static final Set<Integer> countryCodeSet = AlternateFormatsCountryCodeSet.getCountryCodeSet();

    private MetadataManager() {
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMetadataFromFile(int countryCallingCode) {
        InputStream source = PhoneNumberMatcher.class.getResourceAsStream("/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto_" + countryCallingCode);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            Phonemetadata.PhoneMetadataCollection alternateFormats = new Phonemetadata.PhoneMetadataCollection();
            alternateFormats.readExternal(in);
            for (Phonemetadata.PhoneMetadata metadata : alternateFormats.getMetadataList()) {
                callingCodeToAlternateFormatsMap.put(metadata.getCountryCode(), metadata);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                MetadataManager.close(in);
                throw throwable;
            }
            MetadataManager.close(in);
        }
        MetadataManager.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode) {
        if (!countryCodeSet.contains(countryCallingCode)) {
            return null;
        }
        Map<Integer, Phonemetadata.PhoneMetadata> map = callingCodeToAlternateFormatsMap;
        synchronized (map) {
            if (!callingCodeToAlternateFormatsMap.containsKey(countryCallingCode)) {
                MetadataManager.loadMetadataFromFile(countryCallingCode);
            }
        }
        return callingCodeToAlternateFormatsMap.get(countryCallingCode);
    }
}

