/*
 * Copyright 2010-2011 Nabeel Mukhtar 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 * 
 */

package com.google.code.linkedinapi.schema;



/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{}name"/>
 *         &lt;element name="code">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *               &lt;enumeration value="location"/>
 *               &lt;enumeration value="industry"/>
 *               &lt;enumeration value="network"/>
 *               &lt;enumeration value="language"/>
 *               &lt;enumeration value="current-company"/>
 *               &lt;enumeration value="past-company"/>
 *               &lt;enumeration value="school"/>
 *               &lt;enumeration value="company-size"/>
 *               &lt;enumeration value="num-followers-range"/>
 *               &lt;enumeration value="fortune"/>
 *               &lt;enumeration value="company"/>
 *               &lt;enumeration value="date-posted"/>
 *               &lt;enumeration value="job-function"/>
 *               &lt;enumeration value="experience-level"/>
 *               &lt;enumeration value="salary"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element ref="{}buckets" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
public interface Facet
    extends SchemaEntity
{


    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    String getName();

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    void setName(String value);

    /**
     * Gets the value of the code property.
     * 
     * @return
     *     possible object is
     *     {@link FacetType }
     *     
     */
    FacetType getCode();

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link FacetType }
     *     
     */
    void setCode(FacetType value);

    /**
     * Gets the value of the buckets property.
     * 
     * @return
     *     possible object is
     *     {@link Buckets }
     *     
     */
    Buckets getBuckets();

    /**
     * Sets the value of the buckets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Buckets }
     *     
     */
    void setBuckets(Buckets value);

}
