/*
 * Copyright 2010-2011 Nabeel Mukhtar 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 * 
 */

package com.google.code.linkedinapi.schema.impl;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.google.code.linkedinapi.schema.Date;
import com.google.code.linkedinapi.schema.Inventors;
import com.google.code.linkedinapi.schema.Office;
import com.google.code.linkedinapi.schema.Patent;
import com.google.code.linkedinapi.schema.Status;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "id",
    "title",
    "date",
    "url",
    "summary",
    "number",
    "status",
    "office",
    "inventors"
})
@XmlRootElement(name = "patent")
public class PatentImpl
    implements Serializable, Patent
{

    private final static long serialVersionUID = 2461660169443089969L;
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String id;
    @XmlElement(required = true)
    protected String title;
    @XmlElement(required = true, type = DateImpl.class)
    protected DateImpl date;
    @XmlElement(required = true)
    protected String url;
    @XmlElement(required = true)
    protected String summary;
    @XmlElement(required = true)
    protected String number;
    @XmlElement(required = true, type = StatusImpl.class)
    protected StatusImpl status;
    @XmlElement(required = true, type = OfficeImpl.class)
    protected OfficeImpl office;
    @XmlElement(required = true, type = InventorsImpl.class)
    protected InventorsImpl inventors;

    public String getId() {
        return id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date value) {
        this.date = ((DateImpl) value);
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String value) {
        this.summary = value;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String value) {
        this.number = value;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status value) {
        this.status = ((StatusImpl) value);
    }

    public Office getOffice() {
        return office;
    }

    public void setOffice(Office value) {
        this.office = ((OfficeImpl) value);
    }

    public Inventors getInventors() {
        return inventors;
    }

    public void setInventors(Inventors value) {
        this.inventors = ((InventorsImpl) value);
    }

}
