/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.enumeration;

import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import com.google.code.linkedinapi.client.enumeration.SearchEnum;
import com.google.code.linkedinapi.client.enumeration.SearchScope;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SearchParameter implements FieldEnum,
SearchEnum
{
    KEYWORDS("keywords", EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS)),
    FIRST_NAME("first-name", EnumSet.of(SearchScope.PEOPLE)),
    LAST_NAME("last-name", EnumSet.of(SearchScope.PEOPLE)),
    COMPANY_NAME("company-name", EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    CURRENT_COMPANY("current-company", EnumSet.of(SearchScope.PEOPLE)),
    TITLE("title", EnumSet.of(SearchScope.PEOPLE)),
    CURRENT_TITLE("current-title", EnumSet.of(SearchScope.PEOPLE)),
    SCHOOL_NAME("school-name", EnumSet.of(SearchScope.PEOPLE)),
    CURRENT_SCHOOL("current-school", EnumSet.of(SearchScope.PEOPLE)),
    COUNTRY_CODE("country-code", EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    POSTAL_CODE("postal-code", EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    DISTANCE("distance", EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    HEADQUARTER("hq-only", EnumSet.of(SearchScope.COMPANIES)),
    JOB_TITLE("job-title", EnumSet.of(SearchScope.JOBS)),
    FACET("facet", EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS)),
    FACETS("facets", EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS));

    private static final Map<String, SearchParameter> stringToEnum;
    private final String fieldName;
    private final Set<SearchScope> scopes;

    private SearchParameter(String name, Set<SearchScope> scopes) {
        this.fieldName = name;
        this.scopes = scopes;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName();
    }

    @Override
    public boolean hasScope(SearchScope scope) {
        return this.scopes.contains(scope);
    }

    public static SearchParameter fromString(String symbol) {
        return stringToEnum.get(symbol);
    }

    static {
        stringToEnum = new HashMap<String, SearchParameter>();
        for (SearchParameter op : SearchParameter.values()) {
            stringToEnum.put(op.fieldName(), op);
        }
    }
}

