/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.enumeration;

import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import com.google.code.linkedinapi.client.enumeration.SearchEnum;
import com.google.code.linkedinapi.client.enumeration.SearchScope;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SearchSortOrder implements FieldEnum,
SearchEnum
{
    CONNECTIONS("connections", EnumSet.of(SearchScope.PEOPLE)),
    RECOMMENDERS("recommenders", EnumSet.of(SearchScope.PEOPLE)),
    DISTANCE("distance", EnumSet.of(SearchScope.PEOPLE)),
    RELATIONSHIP("relationship", EnumSet.of(SearchScope.COMPANIES)),
    FOLLOWERS("followers", EnumSet.of(SearchScope.COMPANIES)),
    COMPANY_SIZE("company-size", EnumSet.of(SearchScope.COMPANIES)),
    RELEVANCE("relevance", EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES));

    private static final Map<String, SearchSortOrder> stringToEnum;
    private final String fieldName;
    private final Set<SearchScope> scopes;

    private SearchSortOrder(String name, Set<SearchScope> scopes) {
        this.fieldName = name;
        this.scopes = scopes;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName();
    }

    @Override
    public boolean hasScope(SearchScope scope) {
        return this.scopes.contains(scope);
    }

    public static SearchSortOrder fromString(String symbol) {
        return stringToEnum.get(symbol);
    }

    static {
        stringToEnum = new HashMap<String, SearchSortOrder>();
        for (SearchSortOrder op : SearchSortOrder.values()) {
            stringToEnum.put(op.fieldName(), op);
        }
    }
}

