/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.impl;

import com.google.code.linkedinapi.client.JobsApiClient;
import com.google.code.linkedinapi.schema.Company;
import com.google.code.linkedinapi.schema.Country;
import com.google.code.linkedinapi.schema.ExperienceLevel;
import com.google.code.linkedinapi.schema.ExperienceLevelCode;
import com.google.code.linkedinapi.schema.HowToApply;
import com.google.code.linkedinapi.schema.Industries;
import com.google.code.linkedinapi.schema.Industry;
import com.google.code.linkedinapi.schema.Job;
import com.google.code.linkedinapi.schema.JobFunction;
import com.google.code.linkedinapi.schema.JobFunctionCode;
import com.google.code.linkedinapi.schema.JobFunctions;
import com.google.code.linkedinapi.schema.JobType;
import com.google.code.linkedinapi.schema.JobTypeCode;
import com.google.code.linkedinapi.schema.Location;
import com.google.code.linkedinapi.schema.Position;
import com.google.code.linkedinapi.schema.Poster;
import com.google.code.linkedinapi.schema.Role;
import com.google.code.linkedinapi.schema.RoleCode;
import com.google.code.linkedinapi.schema.SchemaElementFactory;

public class JobBuilderImpl
implements JobsApiClient.JobBuilder {
    private final SchemaElementFactory<?> factory;
    private Job job;

    JobBuilderImpl(SchemaElementFactory<?> factory) {
        this.factory = factory;
        this.job = this.factory.createJob();
    }

    @Override
    public Job build() {
        return this.job;
    }

    @Override
    public JobsApiClient.JobBuilder withApplicationUrl(String applicationUrl) {
        HowToApply apply = this.factory.createHowToApply();
        apply.setApplicationUrl(applicationUrl);
        this.job.setHowToApply(apply);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withCompany(String companyId, String companyName, String description) {
        Company company = this.factory.createCompany();
        company.setId(companyId);
        company.setName(companyName);
        company.setDescription(description);
        this.job.setCompany(company);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withContractId(Long value) {
        this.job.setContractId(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withCountry(String country) {
        Country c = this.factory.createCountry();
        c.setCode(country);
        this.getJobLocation().setCountry(c);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withCustomerJobCode(String value) {
        this.job.setCustomerJobCode(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withDescription(String jobDescription) {
        this.getJobPosition().setDescription(jobDescription);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withDisplayPoster(Boolean display) {
        this.getJobPoster().setDisplay(display);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withExperienceLevel(ExperienceLevelCode experienceLevel) {
        ExperienceLevel level = this.factory.createExperienceLevel();
        level.setCode(experienceLevel);
        this.getJobPosition().setExperienceLevel(level);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withIndustries(String ... industries) {
        for (int i = 0; i < industries.length; ++i) {
            Industry industry = this.factory.createIndustry();
            industry.setCode(industries[i]);
            this.getJobIndustries().getIndustryList().add(industry);
        }
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withJobFunctions(JobFunctionCode ... jobFunctions) {
        for (JobFunctionCode jobFunction : jobFunctions) {
            JobFunction function = this.factory.createJobFunction();
            function.setCode(jobFunction);
            this.getJobFunctions().getJobFunctionList().add(function);
        }
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withLocation(String location) {
        this.getJobLocation().setName(location);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withPartnerJobId(String value) {
        this.job.setPartnerJobId(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withPostalCode(String postalCode) {
        this.getJobLocation().setPostalCode(postalCode);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withPosterEmailAddress(String emailAddress) {
        this.getJobPoster().setEmailAddress(emailAddress);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withPosterRole(RoleCode role) {
        Role r = this.factory.createRole();
        r.setCode(role);
        this.getJobPoster().setRole(r);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withReferralBonus(String value) {
        this.job.setReferralBonus(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withRenewal() {
        this.job.setRenewal(this.factory.createRenewal());
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withSalary(String value) {
        this.job.setSalary(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withSkillsAndExperience(String skillsAndExperience) {
        this.getJobPosition().setSkillsAndExperience(skillsAndExperience);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withTitle(String jobTitle) {
        this.getJobPosition().setTitle(jobTitle);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withTrackingPixelUrl(String value) {
        this.job.setTrackingPixelUrl(value);
        return this;
    }

    @Override
    public JobsApiClient.JobBuilder withType(JobTypeCode jobType) {
        JobType value = this.factory.createJobType();
        value.setCode(jobType);
        this.getJobPosition().setJobType(value);
        return this;
    }

    private Position getJobPosition() {
        if (this.job.getPosition() == null) {
            this.job.setPosition(this.factory.createPosition());
        }
        return this.job.getPosition();
    }

    private Location getJobLocation() {
        Position position = this.getJobPosition();
        if (position.getLocation() == null) {
            position.setLocation(this.factory.createLocation());
        }
        return position.getLocation();
    }

    private Poster getJobPoster() {
        if (this.job.getPoster() == null) {
            this.job.setPoster(this.factory.createPoster());
        }
        return this.job.getPoster();
    }

    private Industries getJobIndustries() {
        Position position = this.getJobPosition();
        if (position.getIndustries() == null) {
            position.setIndustries(this.factory.createIndustries());
        }
        return position.getIndustries();
    }

    private JobFunctions getJobFunctions() {
        Position position = this.getJobPosition();
        if (position.getJobFunctions() == null) {
            position.setJobFunctions(this.factory.createJobFunctions());
        }
        return position.getJobFunctions();
    }
}

