/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Certification;
import com.google.code.linkedinapi.schema.Certifications;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.CertificationImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CertificationsImpl
extends BaseSchemaEntity
implements Certifications {
    private static final long serialVersionUID = 2461660169443089969L;
    protected List<Certification> certificationList;
    protected Long total;

    @Override
    public List<Certification> getCertificationList() {
        if (this.certificationList == null) {
            this.certificationList = new ArrayList<Certification>();
        }
        return this.certificationList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("certification")) {
                CertificationImpl certificationImpl = new CertificationImpl();
                certificationImpl.init(parser);
                this.getCertificationList().add(certificationImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "certifications");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (Certification certification : this.getCertificationList()) {
            ((CertificationImpl)certification).toXml(serializer);
        }
        serializer.endTag(null, "certifications");
    }
}

