/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Headers;
import com.google.code.linkedinapi.schema.HttpHeader;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.HttpHeaderImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class HeadersImpl
extends BaseSchemaEntity
implements Headers {
    private static final long serialVersionUID = -2641335452688934142L;
    protected List<HttpHeader> httpHeaderList;
    protected Long total;

    @Override
    public List<HttpHeader> getHttpHeaderList() {
        if (this.httpHeaderList == null) {
            this.httpHeaderList = new ArrayList<HttpHeader>();
        }
        return this.httpHeaderList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("http-header")) {
                HttpHeaderImpl httpHeaderImpl = new HttpHeaderImpl();
                httpHeaderImpl.init(parser);
                this.getHttpHeaderList().add(httpHeaderImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "headers");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (HttpHeader httpHeader : this.getHttpHeaderList()) {
            ((HttpHeaderImpl)httpHeader).toXml(serializer);
        }
        serializer.endTag(null, "headers");
    }
}

