/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Language;
import com.google.code.linkedinapi.schema.Languages;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.LanguageImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class LanguagesImpl
extends BaseSchemaEntity
implements Languages {
    private static final long serialVersionUID = 2461660169443089969L;
    protected List<Language> languageList;
    protected Long total;

    @Override
    public List<Language> getLanguageList() {
        if (this.languageList == null) {
            this.languageList = new ArrayList<Language>();
        }
        return this.languageList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("language")) {
                LanguageImpl languageImpl = new LanguageImpl();
                languageImpl.init(parser);
                this.getLanguageList().add(languageImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "languages");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (Language language : this.getLanguageList()) {
            ((LanguageImpl)language).toXml(serializer);
        }
        serializer.endTag(null, "languages");
    }
}

