/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.ItemContent;
import com.google.code.linkedinapi.schema.MailboxItem;
import com.google.code.linkedinapi.schema.Recipients;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.ItemContentImpl;
import com.google.code.linkedinapi.schema.xpp.RecipientsImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class MailboxItemImpl
extends BaseSchemaEntity
implements MailboxItem {
    private static final long serialVersionUID = -8720504708417425242L;
    protected RecipientsImpl recipients;
    protected String subject;
    protected String body;
    protected ItemContentImpl itemContent;

    @Override
    public Recipients getRecipients() {
        return this.recipients;
    }

    @Override
    public void setRecipients(Recipients value) {
        this.recipients = (RecipientsImpl)value;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String value) {
        this.subject = value;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String value) {
        this.body = value;
    }

    @Override
    public ItemContent getItemContent() {
        return this.itemContent;
    }

    @Override
    public void setItemContent(ItemContent value) {
        this.itemContent = (ItemContentImpl)value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("recipients")) {
                RecipientsImpl recipientsImpl = new RecipientsImpl();
                recipientsImpl.init(parser);
                this.setRecipients(recipientsImpl);
                continue;
            }
            if (name.equals("item-content")) {
                ItemContentImpl itemContentImpl = new ItemContentImpl();
                itemContentImpl.init(parser);
                this.setItemContent(itemContentImpl);
                continue;
            }
            if (name.equals("subject")) {
                this.setSubject(XppUtils.getElementValueFromNode(parser));
                continue;
            }
            if (name.equals("body")) {
                this.setBody(XppUtils.getElementValueFromNode(parser));
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "mailbox-item");
        XppUtils.setElementValueToNode(element, "subject", this.getSubject());
        XppUtils.setElementValueToNode(element, "body", this.getBody());
        if (this.getRecipients() != null) {
            ((RecipientsImpl)this.getRecipients()).toXml(serializer);
        }
        if (this.getItemContent() != null) {
            ((ItemContentImpl)this.getItemContent()).toXml(serializer);
        }
        serializer.endTag(null, "mailbox-item");
    }
}

