/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Patent;
import com.google.code.linkedinapi.schema.Patents;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.PatentImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PatentsImpl
extends BaseSchemaEntity
implements Patents {
    private static final long serialVersionUID = 2461660169443089969L;
    protected List<Patent> patentList;
    protected Long total;

    @Override
    public List<Patent> getPatentList() {
        if (this.patentList == null) {
            this.patentList = new ArrayList<Patent>();
        }
        return this.patentList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("patent")) {
                PatentImpl patentImpl = new PatentImpl();
                patentImpl.init(parser);
                this.getPatentList().add(patentImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "patents");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (Patent patent : this.getPatentList()) {
            ((PatentImpl)patent).toXml(serializer);
        }
        serializer.endTag(null, "patents");
    }
}

