/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Publication;
import com.google.code.linkedinapi.schema.Publications;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.PublicationImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PublicationsImpl
extends BaseSchemaEntity
implements Publications {
    private static final long serialVersionUID = 2461660169443089969L;
    protected List<Publication> publicationList;
    protected Long total;

    @Override
    public List<Publication> getPublicationList() {
        if (this.publicationList == null) {
            this.publicationList = new ArrayList<Publication>();
        }
        return this.publicationList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("publication")) {
                PublicationImpl publicationImpl = new PublicationImpl();
                publicationImpl.init(parser);
                this.getPublicationList().add(publicationImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "publications");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (Publication publication : this.getPublicationList()) {
            ((PublicationImpl)publication).toXml(serializer);
        }
        serializer.endTag(null, "publications");
    }
}

