/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Recipient;
import com.google.code.linkedinapi.schema.Recipients;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.RecipientImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RecipientsImpl
extends BaseSchemaEntity
implements Recipients {
    private static final long serialVersionUID = 5874984453850790428L;
    protected List<Recipient> recipientList;

    @Override
    public List<Recipient> getRecipientList() {
        if (this.recipientList == null) {
            this.recipientList = new ArrayList<Recipient>();
        }
        return this.recipientList;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("recipient")) {
                RecipientImpl recipientImpl = new RecipientImpl();
                recipientImpl.init(parser);
                this.getRecipientList().add(recipientImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "recipients");
        for (Recipient recepient : this.getRecipientList()) {
            ((RecipientImpl)recepient).toXml(element);
        }
        serializer.endTag(null, "recipients");
    }
}

