/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import com.google.code.linkedinapi.schema.Person;
import com.google.code.linkedinapi.schema.RelatedConnections;
import com.google.code.linkedinapi.schema.xpp.BaseSchemaEntity;
import com.google.code.linkedinapi.schema.xpp.PersonImpl;
import com.google.code.linkedinapi.schema.xpp.XppUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RelatedConnectionsImpl
extends BaseSchemaEntity
implements RelatedConnections {
    private static final long serialVersionUID = 2040264547587096732L;
    protected List<Person> personList;
    protected Long total;

    @Override
    public List<Person> getPersonList() {
        if (this.personList == null) {
            this.personList = new ArrayList<Person>();
        }
        return this.personList;
    }

    @Override
    public Long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(Long value) {
        this.total = value;
    }

    @Override
    public void init(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, null);
        this.setTotal(XppUtils.getAttributeValueAsLongFromNode(parser, "total"));
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if (name.equals("person")) {
                PersonImpl personImpl = new PersonImpl();
                personImpl.init(parser);
                this.getPersonList().add(personImpl);
                continue;
            }
            this.LOG.warning("Found tag that we don't recognize: " + name);
            XppUtils.skipSubTree(parser);
        }
    }

    @Override
    public void toXml(XmlSerializer serializer) throws IOException {
        XmlSerializer element = serializer.startTag(null, "people");
        XppUtils.setAttributeValueToNode(element, "total", this.getTotal());
        for (Person person : this.getPersonList()) {
            ((PersonImpl)person).toXml(serializer);
        }
        serializer.endTag(null, "people");
    }
}

