/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.schema.xpp;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XppUtils {
    public static void setElementValueToNode(XmlSerializer serializer, String elementName, Object elementValue) throws IOException {
        if (elementValue != null) {
            serializer.startTag(null, elementName).text(elementValue.toString()).endTag(null, elementName);
        }
    }

    public static void setElementValue(XmlSerializer serializer, Object elementValue) throws IOException {
        if (elementValue != null) {
            serializer.text(elementValue.toString());
        }
    }

    public static void setAttributeValueToNode(XmlSerializer serializer, String attributeName, Object attributeValue) throws IOException {
        if (attributeValue != null) {
            serializer.attribute(null, attributeName, String.valueOf(attributeValue));
        }
    }

    public static String getElementValueFromNode(XmlPullParser node) throws XmlPullParserException, IOException {
        return node.nextText();
    }

    public static Long getElementValueAsLongFromNode(XmlPullParser node) throws IOException, XmlPullParserException {
        String value = node.nextText();
        if (XppUtils.isNullOrEmpty(value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static String getAttributeValueFromNode(XmlPullParser node, String attributeName) {
        return node.getAttributeValue(null, attributeName);
    }

    public static Long getAttributeValueAsLongFromNode(XmlPullParser node, String attributeName) {
        String attribute = node.getAttributeValue(null, attributeName);
        if (XppUtils.isNullOrEmpty(attribute)) {
            return null;
        }
        return Long.valueOf(attribute);
    }

    public static void skipSubTree(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, null, null);
        int level = 1;
        while (level > 0) {
            int eventType = parser.next();
            if (eventType == 3) {
                --level;
                continue;
            }
            if (eventType != 2) continue;
            ++level;
        }
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

