/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public class MyArtifactResolver {
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private ArtifactRepository local;
    private List<ArtifactRepository> remoteRepositories;
    private boolean resolveAllways = false;

    @Deprecated
    public MyArtifactResolver(ArtifactResolver resolver, ArtifactFactory factory, ArtifactRepository local, List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
        this.factory = factory;
        this.resolver = resolver;
        this.local = local;
    }

    public MyArtifactResolver(AbstractT7Mojo t7Mojo) {
        this.remoteRepositories = t7Mojo.remoteRepos;
        this.local = t7Mojo.local;
        this.resolver = t7Mojo.resolver;
        this.factory = t7Mojo.factory;
        this.resolveAllways = t7Mojo.resolverUpdateSnapshotsAllways;
    }

    public Artifact resolve(String groupId, String artifactId, String version, String type, String scope) throws MojoExecutionException {
        if (version.endsWith("SNAPSHOT")) {
            this.remoteRepositories.add(this.createStagingRepository());
            this.remoteRepositories.add(this.createSnapshotsRepository());
        }
        Artifact artifact = this.factory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), type, null, "compile");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    private ArtifactRepository createSnapshotsRepository() {
        DefaultArtifactRepository repository = new DefaultArtifactRepository("t7mp.apache.tomcat.snapshots", "http://people.apache.org/repo/m2-snapshot-repository", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), this.createSnapshotPolicy(), this.createRelasesPolicy());
        return repository;
    }

    private ArtifactRepository createStagingRepository() {
        DefaultArtifactRepository repository = new DefaultArtifactRepository("t7mp.apache.tomcat.dev", "http://tomcat.apache.org/dev/dist/m2-repository", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), this.createSnapshotPolicy(), this.createRelasesPolicy());
        return repository;
    }

    private ArtifactRepositoryPolicy createSnapshotPolicy() {
        String updatePolicy = "always";
        if (!this.resolveAllways) {
            updatePolicy = "daily";
        }
        return new ArtifactRepositoryPolicy(true, updatePolicy, "warn");
    }

    private ArtifactRepositoryPolicy createRelasesPolicy() {
        return new ArtifactRepositoryPolicy(false, "daily", "warn");
    }

    public Artifact resolveJar(String groupId, String artifactId, String version) throws MojoExecutionException {
        return this.resolve(groupId, artifactId, version, "jar", "compile");
    }

    public Artifact resolveWar(String groupId, String artifactId, String version) throws MojoExecutionException {
        return this.resolve(groupId, artifactId, version, "war", "compile");
    }
}

