/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.DefaultTomcatSetup;
import com.googlecode.t7mp.PreConditions;
import com.googlecode.t7mp.Scanner;
import com.googlecode.t7mp.ScannerConfiguration;
import com.googlecode.t7mp.TomcatSetup;
import com.googlecode.t7mp.TomcatShutdownHook;
import java.io.File;
import org.apache.catalina.startup.Bootstrap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunMojo
extends AbstractT7Mojo {
    protected Bootstrap bootstrap;
    protected TomcatSetup tomcatSetup;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PreConditions.checkConfiguredTomcatVersion(this.getLog(), this.tomcatVersion);
        this.tomcatSetup = this.getTomcatSetup();
        this.tomcatSetup.buildTomcat();
        this.bootstrap = this.getBootstrap();
        this.getLog().info((CharSequence)"Starting Tomcat ...");
        try {
            this.bootstrap.init();
            TomcatShutdownHook shutdownHook = new TomcatShutdownHook(this.bootstrap);
            for (ScannerConfiguration scannerConfiguration : this.getScanners()) {
                scannerConfiguration.setRootDirectory(this.webappSourceDirectory);
                scannerConfiguration.setWebappDirectory(new File(this.catalinaBase, "webapps/" + this.buildFinalName));
                Scanner scanner = new Scanner(scannerConfiguration, this.getLog());
                scanner.start();
                shutdownHook.addScanner(scanner);
            }
            if (this.scanClasses) {
                ScannerConfiguration scannerConfiguration = new ScannerConfiguration();
                scannerConfiguration.setRootDirectory(this.webappClassDirectory);
                scannerConfiguration.setWebappDirectory(new File(this.catalinaBase, "webapps/" + this.buildFinalName + "/WEB-INF/classes"));
                scannerConfiguration.setEndings("%");
                Scanner scanner = new Scanner(scannerConfiguration, this.getLog());
                scanner.start();
                shutdownHook.addScanner(scanner);
            }
            if (this.tomcatSetAwait) {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                this.bootstrap.setAwait(this.tomcatSetAwait);
                this.bootstrap.start();
            } else {
                this.bootstrap.start();
                this.getPluginContext().put("com.googlecode.t7mp.Bootstrap", this.bootstrap);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                this.getLog().info((CharSequence)"Tomcat started");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected TomcatSetup getTomcatSetup() {
        return new DefaultTomcatSetup(this);
    }

    protected Bootstrap getBootstrap() {
        return new Bootstrap();
    }
}

